/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FCMTopicManager {
    private static final Logger logger = LoggerFactory.getLogger(FCMTopicManager.class);
    public static final String IID_URL = "https://iid.googleapis.com/iid/v1/";
    private AndroidVariant variant;

    public FCMTopicManager(AndroidVariant variant) {
        this.variant = variant;
    }

    public Set<String> getSubscribedCategories(Installation installation) {
        JSONObject info;
        String deviceInfo;
        String url = "https://iid.googleapis.com/iid/v1/info/" + installation.getDeviceToken() + "?details=true";
        try {
            deviceInfo = this.get(url);
        }
        catch (IOException e) {
            logger.debug("Couldn't get list of subscribed topics from Instance ID service.");
            return Collections.emptySet();
        }
        JSONParser parser = new JSONParser();
        try {
            info = (JSONObject)parser.parse(deviceInfo);
        }
        catch (ParseException e) {
            logger.debug("Couldn't parse list of subscribed topics from Instance ID service.");
            return Collections.emptySet();
        }
        JSONObject rel = (JSONObject)info.get((Object)"rel");
        if (rel == null) {
            logger.debug("Couldn't parse rel object Instance ID service.");
            return Collections.emptySet();
        }
        JSONObject topics = (JSONObject)rel.get((Object)"topics");
        return topics.keySet();
    }

    public void unsubscribe(Installation installation, String categoryToUnsubscribe) {
        String url = "";
        try {
            url = IID_URL + installation.getDeviceToken() + "/rel/topics/" + URLEncoder.encode(categoryToUnsubscribe, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            this.delete(url);
        }
        catch (IOException e) {
            logger.debug("Unregistering device from topic was unsuccessfull");
        }
    }

    private int delete(String urlS) throws IOException {
        URL url = new URL(urlS);
        HttpURLConnection conn = this.prepareAuthorizedConnection(url);
        conn.setRequestMethod("DELETE");
        conn.connect();
        return conn.getResponseCode();
    }

    private String get(String urlS) throws IOException {
        URL url = new URL(urlS);
        HttpURLConnection conn = this.prepareAuthorizedConnection(url);
        conn.setRequestMethod("GET");
        StringBuilder result = new StringBuilder();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        return result.toString();
    }

    private HttpURLConnection prepareAuthorizedConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Authorization", "key=" + this.variant.getGoogleKey());
        return conn;
    }
}

