/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush;

import java.util.HashSet;
import java.util.Set;
import org.jboss.aerogear.webpush.util.Arguments;

public class AggregateSubscription {
    private final Set<Entry> subscriptions;

    public AggregateSubscription(Set<Entry> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public static AggregateSubscription from(String channelsCsv) {
        return new AggregateSubscription(AggregateSubscription.asEntries(channelsCsv.split(",")));
    }

    public Set<Entry> subscriptions() {
        return this.subscriptions;
    }

    public String toString() {
        return "DefaulEntry[subscriptions=" + this.subscriptions + "]";
    }

    public static Set<Entry> asEntries(String[] endpointUrls) {
        HashSet<Entry> entries = new HashSet<Entry>(endpointUrls.length);
        for (String url : endpointUrls) {
            entries.add(new DefaultEntry(url, 0L, null));
        }
        return entries;
    }

    public static final class DefaultEntry
    implements Entry {
        private final String endpoint;
        private final Long expires;
        private final byte[] pubkey;

        public DefaultEntry(String endpoint, long expires, byte[] pubkey) {
            Arguments.checkNotNull(endpoint, "endpoint must not be null");
            Arguments.checkNotNull(expires, "expires must not be null");
            this.endpoint = endpoint;
            this.expires = expires;
            this.pubkey = pubkey;
        }

        @Override
        public String endpoint() {
            return this.endpoint;
        }

        @Override
        public long expires() {
            return this.expires;
        }

        @Override
        public byte[] pubkey() {
            return this.pubkey;
        }

        public String toString() {
            return "DefaulEntry[endpoint=" + this.endpoint + ", expires=" + this.expires + ", pubkey=" + this.pubkey + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultEntry that = (DefaultEntry)o;
            if (!this.endpoint.equals(that.endpoint)) {
                return false;
            }
            if (this.expires != that.expires) {
                return false;
            }
            return this.pubkey == that.pubkey;
        }

        public int hashCode() {
            int result = this.endpoint.hashCode();
            result = 31 * result + this.expires.hashCode();
            if (this.pubkey != null) {
                result = 31 * result + this.pubkey.hashCode();
            }
            return result;
        }
    }

    static interface Entry {
        public String endpoint();

        public long expires();

        public byte[] pubkey();
    }
}

