/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.completer.CompleterData;
import org.jboss.aesh.cl.completer.DefaultValueOptionCompleter;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.CommandLineCompletionParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.ParsedCompleteObject;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalString;

public class AeshCommandLineCompletionParser
implements CommandLineCompletionParser {
    private final CommandLineParser parser;

    public AeshCommandLineCompletionParser(CommandLineParser parser) {
        this.parser = parser;
    }

    @Override
    public ParsedCompleteObject findCompleteObject(String line, int cursor) throws CommandLineParserException {
        if (cursor < line.length()) {
            line = line.substring(0, cursor);
        }
        if (Parser.findIfWordEndWithSpace(line)) {
            if (line.trim().equals(this.parser.getCommand().getName())) {
                if (this.parser.getCommand().getArgument() == null) {
                    return new ParsedCompleteObject(true, "", 0);
                }
                return new ParsedCompleteObject(null, "", this.parser.getCommand().getArgument().getType(), false);
            }
            String lastWord = Parser.findEscapedSpaceWordCloseToEnd(line.trim());
            if (lastWord.startsWith("-")) {
                int offset = lastWord.length();
                while (lastWord.startsWith("-")) {
                    lastWord = lastWord.substring(1);
                }
                if (lastWord.length() == 0) {
                    return new ParsedCompleteObject(false, null, offset);
                }
                if (this.parser.getCommand().findOptionNoActivatorCheck(lastWord) != null || this.parser.getCommand().findLongOptionNoActivatorCheck(lastWord) != null) {
                    return this.findCompleteObjectValue(line, true);
                }
                return new ParsedCompleteObject(false, null, offset);
            }
            return this.findCompleteObjectValue(line, true);
        }
        return this.optionFinder(line);
    }

    private ParsedCompleteObject optionFinder(String line) throws CommandLineParserException {
        String lastWord = Parser.findEscapedSpaceWordCloseToEnd(line);
        if (lastWord.startsWith("-")) {
            String secLastWord = Parser.findEscapedSpaceWordCloseToEnd(line.substring(0, line.length() - lastWord.length()));
            if (secLastWord.startsWith("-")) {
                return this.findCompleteObjectValue(line, false);
            }
            switch (lastWord) {
                case "-": {
                    return new ParsedCompleteObject(true, "", 1);
                }
                case "--": {
                    return new ParsedCompleteObject(true, "", 2);
                }
            }
            if (!lastWord.startsWith("--") && lastWord.length() == 2) {
                return new ParsedCompleteObject(true, Parser.trimOptionName(lastWord), lastWord.length(), true);
            }
            String optionName = Parser.trimOptionName(lastWord);
            if (this.parser.getCommand().hasUniqueLongOption(optionName)) {
                return new ParsedCompleteObject(true, optionName, lastWord.length(), true);
            }
            return new ParsedCompleteObject(true, optionName, lastWord.length(), false);
        }
        return this.findCompleteObjectValue(line, false);
    }

    private ParsedCompleteObject findCompleteObjectValue(String line, boolean endsWithSpace) throws CommandLineParserException {
        CommandLine cl = this.parser.parse(line, true);
        if (cl.getArgument() != null && !cl.getArgument().getValues().isEmpty()) {
            return new ParsedCompleteObject("", endsWithSpace ? "" : cl.getArgument().getValues().get(cl.getArgument().getValues().size() - 1), cl.getArgument().getType(), false);
        }
        if (cl.getOptions() != null && cl.getOptions().size() > 0) {
            ProcessedOption po = cl.getOptions().get(cl.getOptions().size() - 1);
            if (po.getEndsWithSeparator()) {
                endsWithSpace = true;
            }
            if (endsWithSpace && po.getValue() != null && po.getValue().length() > 0 && (po.getOptionType() == OptionType.NORMAL || po.getOptionType() == OptionType.BOOLEAN)) {
                if (cl.getArgument() == null) {
                    return new ParsedCompleteObject(true, "", 0);
                }
                return new ParsedCompleteObject(true);
            }
            if (po.isLongNameUsed() || po.getShortName() == null || po.getShortName().length() < 1) {
                return new ParsedCompleteObject(po.getName(), endsWithSpace ? "" : po.getValues().get(po.getValues().size() - 1), po.getType(), true);
            }
            return new ParsedCompleteObject(po.getShortName(), endsWithSpace ? "" : po.getValues().get(po.getValues().size() - 1), po.getType(), true);
        }
        return new ParsedCompleteObject(true, "", 0);
    }

    @Override
    public void injectValuesAndComplete(ParsedCompleteObject completeObject, Command command, CompleteOperation completeOperation, InvocationProviders invocationProviders) {
        if (completeObject.doDisplayOptions()) {
            if (completeObject.isCompleteOptionName()) {
                completeOperation.addCompletionCandidate("");
            } else {
                this.parser.parse(completeOperation.getBuffer(), true);
                if (completeObject.getName() != null && completeObject.getName().length() > 0) {
                    String rest = completeOperation.getBuffer().substring(0, completeOperation.getBuffer().lastIndexOf(completeObject.getName()));
                    try {
                        this.parser.getCommandPopulator().populateObject(command, this.parser.parse(rest), invocationProviders, completeOperation.getAeshContext(), false);
                    }
                    catch (CommandLineParserException | OptionValidatorException ignored) {
                        // empty catch block
                    }
                    List<TerminalString> optionNamesWithDash = this.parser.getCommand().findPossibleLongNamesWitdDash(completeObject.getName());
                    if (optionNamesWithDash.size() > 0) {
                        if (optionNamesWithDash.size() == 1) {
                            completeOperation.addCompletionCandidate(optionNamesWithDash.get(0));
                            completeOperation.setOffset(completeOperation.getCursor() - 2 - completeObject.getName().length());
                        } else {
                            completeOperation.addCompletionCandidatesTerminalString(optionNamesWithDash);
                            completeOperation.setOffset(completeOperation.getCursor() - 2 - completeObject.getName().length());
                        }
                    }
                } else {
                    try {
                        this.parser.getCommandPopulator().populateObject(command, this.parser.parse(completeOperation.getBuffer()), invocationProviders, completeOperation.getAeshContext(), false);
                    }
                    catch (CommandLineParserException | OptionValidatorException ignored) {
                        // empty catch block
                    }
                    List<TerminalString> optionNamesWithDash = this.parser.getCommand().getOptionLongNamesWithDash();
                    if (optionNamesWithDash.size() > 1) {
                        completeOperation.addCompletionCandidatesTerminalString(optionNamesWithDash);
                    } else if (optionNamesWithDash.size() == 1) {
                        int count = 0;
                        if (completeOperation.getCursor() < completeOperation.getBuffer().length()) {
                            String line = completeOperation.getBuffer().substring(0, completeOperation.getCursor());
                            while (line.substring(0, line.length() - count).endsWith("-")) {
                                ++count;
                            }
                        } else {
                            while (completeOperation.getBuffer().substring(0, completeOperation.getBuffer().length() - count).endsWith("-")) {
                                ++count;
                            }
                        }
                        completeOperation.addCompletionCandidate(optionNamesWithDash.get(0));
                        completeOperation.setOffset(completeOperation.getCursor() - count);
                    }
                }
            }
        } else if (completeObject.isOption()) {
            String displayName;
            ProcessedOption currentOption = this.parser.getCommand().findOption(completeObject.getName());
            if (currentOption == null) {
                currentOption = this.parser.getCommand().findLongOptionNoActivatorCheck(completeObject.getName());
            }
            if ((displayName = currentOption.getDisplayName()) == null) {
                return;
            }
            String rest = completeOperation.getBuffer().substring(0, completeOperation.getBuffer().lastIndexOf(displayName));
            try {
                this.parser.getCommandPopulator().populateObject(command, this.parser.parse(rest), invocationProviders, completeOperation.getAeshContext(), false);
            }
            catch (CommandLineParserException | OptionValidatorException ignored) {
                // empty catch block
            }
            if (currentOption.getCompleter() != null && currentOption.getActivator().isActivated(this.parser.getCommand())) {
                Object completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), command));
                currentOption.getCompleter().complete(completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                    completeOperation.doAppendSeparator(completions.isAppendSpace());
                }
            } else if (currentOption.getDefaultValues().size() > 0) {
                Object completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), command));
                new DefaultValueOptionCompleter(currentOption.getDefaultValues()).complete((CompleterInvocation)completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                    completeOperation.doAppendSeparator(completions.isAppendSpace());
                }
            }
        } else if (completeObject.isArgument()) {
            String lastWord = Parser.findEscapedSpaceWordCloseToEnd(completeOperation.getBuffer());
            String rest = completeOperation.getBuffer().substring(0, completeOperation.getBuffer().length() - lastWord.length());
            try {
                this.parser.getCommandPopulator().populateObject(command, this.parser.parse(rest), invocationProviders, completeOperation.getAeshContext(), false);
            }
            catch (CommandLineParserException | OptionValidatorException ignored) {
                // empty catch block
            }
            if (this.parser.getCommand().getArgument() != null && this.parser.getCommand().getArgument().getCompleter() != null) {
                Object completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), command));
                this.parser.getCommand().getArgument().getCompleter().complete(completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                    completeOperation.doAppendSeparator(completions.isAppendSpace());
                }
            } else if (this.parser.getCommand().getArgument() != null && this.parser.getCommand().getArgument().getDefaultValues().size() > 0) {
                Object completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), command));
                new DefaultValueOptionCompleter(this.parser.getCommand().getArgument().getDefaultValues()).complete((CompleterInvocation)completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                }
                completeOperation.doAppendSeparator(completions.isAppendSpace());
            }
        }
    }
}

