/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto.signature;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.jboss.aerogear.crypto.encoders.Encoder;
import org.jboss.aerogear.crypto.keys.KeyPair;
import org.jboss.aerogear.crypto.signature.VerifyKey;

public class SigningKey {
    private final PublicKey publicKey;
    private Signature ecdsaSign;

    public SigningKey(KeyPair keyPair) {
        this.publicKey = keyPair.getPublicKey();
        try {
            this.ecdsaSign = Signature.getInstance("SHA256withECDSA");
            this.ecdsaSign.initSign(keyPair.getPrivateKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: ", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Error: ", e);
        }
    }

    public SigningKey() {
        this(new KeyPair("ECDSA", "P-256"));
    }

    public byte[] sign(byte[] message) {
        byte[] signature;
        try {
            this.ecdsaSign.update(message);
            signature = this.ecdsaSign.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException("Error: ", e);
        }
        return signature;
    }

    public String sign(String message, Encoder encoder) {
        byte[] signature = this.sign(encoder.decode(message));
        return encoder.encode(signature);
    }

    public String sign(String message) {
        return this.sign(message, Encoder.RAW);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public static void main(String[] args) throws SignatureException, InvalidKeyException {
        SigningKey key = new SigningKey();
        byte[] signature = key.sign("meh".getBytes());
        VerifyKey verifyKey = new VerifyKey(key.getPublicKey());
        boolean result = verifyKey.verify("meh".getBytes(), signature);
        System.out.println(result);
    }
}

