/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.crypto.BlockCipher;
import org.jboss.aerogear.crypto.CryptoBox;
import org.jboss.aerogear.crypto.encoders.Encoder;

public final class CryptoUtil {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final int IV_SIZE = 16;

    private CryptoUtil() {
    }

    public static String encrypt(byte[] key, String content) throws Exception {
        byte[] iv = BlockCipher.getIV();
        byte[] encrypted = new CryptoBox(key).encrypt(iv, content.getBytes(ASCII));
        String base64 = Encoder.BASE64.encode(CryptoUtil.prependIV(encrypted, iv));
        return URLEncoder.encode(base64, ASCII.displayName());
    }

    private static byte[] prependIV(byte[] target, byte[] iv) {
        byte[] withIV = new byte[target.length + 16];
        System.arraycopy(iv, 0, withIV, 0, 16);
        System.arraycopy(target, 0, withIV, 16, target.length);
        return withIV;
    }

    public static String decrypt(byte[] key, String content) throws Exception {
        byte[] decodedContent = Encoder.BASE64.decode(URLDecoder.decode(content, ASCII.displayName()));
        byte[] iv = CryptoUtil.extractIV(decodedContent);
        byte[] decrypted = new CryptoBox(key).decrypt(iv, CryptoUtil.extractContent(decodedContent));
        return new String(decrypted, ASCII);
    }

    private static byte[] extractIV(byte[] from) {
        byte[] iv = new byte[16];
        System.arraycopy(from, 0, iv, 0, iv.length);
        return iv;
    }

    private static byte[] extractContent(byte[] from) {
        byte[] decodedContent = new byte[from.length - 16];
        System.arraycopy(from, 16, decodedContent, 0, from.length - 16);
        return decodedContent;
    }

    public static byte[] secretKey(String password, byte[] salt) {
        try {
            return AeroGearCrypto.pbkdf2().generateSecretKey(password, salt, 100000).getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String endpointToken(String uaid, String subscriptionId, byte[] key) {
        try {
            String path = uaid + "." + subscriptionId;
            return CryptoUtil.encrypt(key, path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

