/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.history.InMemoryHistory;

public class FileHistory
extends InMemoryHistory {
    private final File historyFile;

    public FileHistory(File file, int maxSize) throws IOException {
        super(maxSize);
        this.historyFile = file;
        this.readFile();
    }

    private void readFile() throws IOException {
        if (this.historyFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.historyFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.push(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private void writeFile() throws IOException {
        this.historyFile.delete();
        try (FileWriter fw = new FileWriter(this.historyFile);){
            for (int i = 0; i < this.size(); ++i) {
                fw.write(this.get(i) + Config.getLineSeparator());
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.writeFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

