/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto.signature;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.jboss.aerogear.crypto.encoders.Encoder;

public class VerifyKey {
    private final Signature ecdsaSign;

    public VerifyKey(PublicKey publicKey) {
        try {
            this.ecdsaSign = Signature.getInstance("SHA256withECDSA");
            this.ecdsaSign.initVerify(publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: ", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Error: ", e);
        }
    }

    public boolean verify(byte[] message, byte[] signature) {
        boolean isValid;
        try {
            this.ecdsaSign.update(message);
            isValid = this.ecdsaSign.verify(signature);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Corrupted message", e);
        }
        return isValid;
    }

    public Boolean verify(String message, String signature, Encoder encoder) {
        return this.verify(encoder.decode(message), encoder.decode(signature));
    }

    public Boolean verify(String message, String signature) throws SignatureException, InvalidKeyException {
        return this.verify(message, signature, Encoder.RAW);
    }

    public Boolean verify(String message, byte[] signature) throws SignatureException, InvalidKeyException {
        return this.verify(Encoder.RAW.decode(message), signature);
    }
}

