/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.webpush.EventHandler;

public class HttpResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private final SortedMap<Integer, ChannelPromise> streamidPromiseMap = new TreeMap<Integer, ChannelPromise>();
    private final EventHandler handler;

    public HttpResponseHandler(EventHandler handler) {
        this.handler = handler;
    }

    public ChannelPromise put(int streamId, ChannelPromise promise) {
        return this.streamidPromiseMap.put(streamId, promise);
    }

    public void awaitResponses(long timeout, TimeUnit unit) {
        Iterator<Map.Entry<Integer, ChannelPromise>> itr = this.streamidPromiseMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Integer, ChannelPromise> entry = itr.next();
            ChannelPromise promise = entry.getValue();
            if (!promise.awaitUninterruptibly(timeout, unit)) {
                throw new IllegalStateException("Timed out waiting for response on stream id " + entry.getKey());
            }
            if (!promise.isSuccess()) {
                throw new RuntimeException(promise.cause());
            }
            System.out.println("---Stream id: " + entry.getKey() + " received---");
            itr.remove();
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.handler.message("Channel with id " + ctx.channel().id() + ", became inactive/disonnected.");
        super.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        super.exceptionCaught(ctx, cause);
    }
}

