/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static <T> T newInstance(Class<T> clazz) {
        Object object;
        if (clazz.isAnonymousClass()) {
            throw new RuntimeException("Can not create new instance of an anonymous class");
        }
        if (clazz.isInterface()) {
            throw new RuntimeException("Can not create new instance of an interface");
        }
        if (clazz.isAnnotation()) {
            throw new RuntimeException("Can not create new instance of an annotation");
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            object = ReflectionUtil.instantiateWithConstructor(constructor);
            if (object == null) continue;
            return (T)object;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            object = ReflectionUtil.instantiateWithConstructor(constructor);
            if (object == null) continue;
            return (T)object;
        }
        throw new RuntimeException("Could not instantiate class: " + clazz + ", no access to constructors.");
    }

    private static <T> T instantiateWithConstructor(Constructor<T> constructor) {
        block13: {
            if (constructor.getParameterTypes().length == 0) {
                if (Modifier.isPrivate(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers())) {
                    constructor.setAccessible(true);
                }
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    break block13;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block13;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    break block13;
                }
            }
            if (constructor.getParameterTypes().length == 1) {
                Constructor paramConstructor;
                if (Modifier.isPrivate(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers())) {
                    constructor.setAccessible(true);
                }
                if ((paramConstructor = ReflectionUtil.getConstructorWithNoParams(constructor.getParameterTypes()[0])) != null) {
                    try {
                        return constructor.newInstance(paramConstructor.newInstance(new Object[0]));
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private static Constructor getConstructorWithNoParams(Class clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            if (Modifier.isPrivate(constructor.getModifiers()) || Modifier.isProtected(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        return null;
    }
}

