/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseAggregator;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.jboss.aerogear.webpush.EventHandler;
import org.jboss.aerogear.webpush.Http2SettingsHandler;
import org.jboss.aerogear.webpush.HttpResponseHandler;
import org.jboss.aerogear.webpush.WebPushFrameListener;
import org.jboss.aerogear.webpush.WebPushMessage;

public class WebPushClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private final EventHandler callback;
    private final String host;
    private final int port;
    private WebPushToHttp2ConnectionHandler connectionHandler;
    private HttpResponseHandler responseHandler;
    private Http2SettingsHandler settingsHandler;

    public WebPushClientInitializer(SslContext sslCtx, String host, int port, EventHandler callback) {
        this.sslCtx = sslCtx;
        this.callback = callback;
        this.host = host;
        this.port = port;
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        this.connectionHandler = new WebPushToHttp2ConnectionHandler(connection, new DefaultHttp2FrameReader(), new DefaultHttp2FrameWriter(), new DelegatingDecompressorFrameListener(new DefaultHttp2Connection(false), new WebPushFrameListener(this.callback)));
        this.responseHandler = new HttpResponseHandler(this.callback);
        this.settingsHandler = new Http2SettingsHandler(ch.newPromise());
        if (this.sslCtx != null) {
            this.configureSsl(ch);
        } else {
            this.configureClearText(ch);
        }
    }

    public HttpResponseHandler responseHandler() {
        return this.responseHandler;
    }

    public Http2SettingsHandler settingsHandler() {
        return this.settingsHandler;
    }

    protected void configureEndOfPipeline(ChannelPipeline pipeline) {
        pipeline.addLast("Http2SettingsHandler", (ChannelHandler)this.settingsHandler);
        pipeline.addLast("HttpResponseHandler", (ChannelHandler)this.responseHandler);
    }

    private void configureSsl(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.sslCtx.newHandler(ch.alloc(), this.host, this.port);
        sslHandler.handshakeFuture().addListener(new SslHandshakeListener(this.callback));
        pipeline.addLast("SslHandler", (ChannelHandler)sslHandler);
        pipeline.addLast("Http2Handler", (ChannelHandler)this.connectionHandler);
        ch.pipeline().addLast("Logger", (ChannelHandler)new UserEventLogger(this.callback));
        this.configureEndOfPipeline(pipeline);
    }

    private void configureClearText(SocketChannel ch) {
        HttpClientCodec sourceCodec = new HttpClientCodec();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(this.connectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler(sourceCodec, upgradeCodec, 65536);
        ch.pipeline().addLast("Http2SourceCodec", (ChannelHandler)sourceCodec);
        ch.pipeline().addLast("Http2UpgradeHandler", (ChannelHandler)upgradeHandler);
        ch.pipeline().addLast("Http2UpgradeRequestHandler", (ChannelHandler)new UpgradeRequestHandler());
        ch.pipeline().addLast("Logger", (ChannelHandler)new UserEventLogger(this.callback));
    }

    private static class SslHandshakeListener
    implements GenericFutureListener<Future<Channel>> {
        private EventHandler handler;

        private SslHandshakeListener(EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void operationComplete(Future<Channel> future) throws Exception {
            if (!future.isSuccess()) {
                this.handler.message(future.cause().getMessage());
            }
        }
    }

    public static class WebPushToHttp2ConnectionHandler
    extends Http2ConnectionHandler {
        public WebPushToHttp2ConnectionHandler(Http2Connection connection, Http2FrameReader frameReader, Http2FrameWriter frameWriter, Http2FrameListener listener) {
            super(connection, frameReader, frameWriter, listener);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg instanceof WebPushMessage) {
                WebPushMessage message = (WebPushMessage)msg;
                Http2ConnectionEncoder encoder = this.encoder();
                int streamId = this.connection().local().nextStreamId();
                if (message.hasData()) {
                    ChannelPromiseAggregator promiseAggregator = new ChannelPromiseAggregator(promise);
                    ChannelPromise headerPromise = ctx.newPromise();
                    ChannelPromise dataPromise = ctx.newPromise();
                    promiseAggregator.add(headerPromise, dataPromise);
                    encoder.writeHeaders(ctx, streamId, message.headers(), 0, false, headerPromise);
                    encoder.writeData(ctx, streamId, message.payload(), 0, true, dataPromise);
                } else {
                    encoder.writeHeaders(ctx, streamId, message.headers(), 0, true, promise);
                }
            } else {
                ctx.write(msg, promise);
            }
        }

        @Override
        public void onException(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            super.onException(ctx, cause);
        }
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private final EventHandler handler;

        UserEventLogger(EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            SslHandshakeCompletionEvent sslEvent;
            if (evt instanceof SslHandshakeCompletionEvent && !(sslEvent = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                this.handler.message(sslEvent.cause().getMessage());
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private UpgradeRequestHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            ctx.writeAndFlush(upgradeRequest);
            ctx.fireChannelActive();
            ctx.pipeline().remove(this);
            WebPushClientInitializer.this.configureEndOfPipeline(ctx.pipeline());
        }
    }
}

