/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jboss.aerogear.webpush.AggregateSubscription;

public final class JsonMapper {
    private static ObjectMapper om = JsonMapper.createObjectMapper();

    private static ObjectMapper createObjectMapper() {
        om = new ObjectMapper();
        SimpleModule module = new SimpleModule("Module", new Version(1, 0, 0, null, "aerogear", "webpush"));
        module.addDeserializer(AggregateSubscription.class, (JsonDeserializer)new AggregateChannelDeserializer());
        module.addSerializer(AggregateSubscription.class, (JsonSerializer)new AggregateChannelSerializer());
        om.registerModule((Module)module);
        return om;
    }

    private JsonMapper() {
    }

    public static String toJson(Object obj) {
        try {
            return om.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("error trying to parse json [" + obj + ']', e);
        }
    }

    public static String pretty(String json) {
        try {
            Object o = om.readValue(json, Object.class);
            return om.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException("error trying to parse json [" + json + ']', e);
        }
    }

    private static byte[] parseBinaryValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        try {
            return node.binaryValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeExpiresField(long value, JsonGenerator gen) {
        try {
            gen.writeNumberField("expires", value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writePubkeyField(byte[] value, JsonGenerator gen) {
        if (value == null) {
            return;
        }
        try {
            gen.writeBinaryField("pubkey", value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class AggregateChannelSerializer
    extends JsonSerializer<AggregateSubscription> {
        private AggregateChannelSerializer() {
        }

        public void serialize(AggregateSubscription aggregateSubscription, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartArray();
            for (AggregateSubscription.Entry entry : aggregateSubscription.subscriptions()) {
                jgen.writeStartObject();
                jgen.writeObjectFieldStart(entry.endpoint());
                JsonMapper.writeExpiresField(entry.expires(), jgen);
                JsonMapper.writePubkeyField(entry.pubkey(), jgen);
                jgen.writeEndObject();
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
    }

    private static class AggregateChannelDeserializer
    extends JsonDeserializer<AggregateSubscription> {
        private AggregateChannelDeserializer() {
        }

        public AggregateSubscription deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode tree = (JsonNode)oc.readTree(jp);
            LinkedHashSet<AggregateSubscription.Entry> subscriptions = new LinkedHashSet<AggregateSubscription.Entry>();
            if (tree.isArray()) {
                for (JsonNode node : tree) {
                    Map.Entry entry = (Map.Entry)node.fields().next();
                    JsonNode objectNode = (JsonNode)entry.getValue();
                    JsonNode expires = objectNode.get("expires");
                    JsonNode pubkey = objectNode.get("pubkey");
                    subscriptions.add(new AggregateSubscription.DefaultEntry((String)entry.getKey(), expires.asLong(0L), JsonMapper.parseBinaryValue(pubkey)));
                }
            }
            return new AggregateSubscription(subscriptions);
        }
    }
}

