/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2OrHttpChooser;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.aerogear.webpush.EventHandler;
import org.jboss.aerogear.webpush.WebPushClientInitializer;
import org.jboss.aerogear.webpush.WebPushMessage;

public class WebPushClient {
    private final String host;
    private final int port;
    private final boolean ssl;
    private final List<String> protocols;
    private NioEventLoopGroup workerGroup;
    private Channel channel;
    private final EventHandler handler;

    private WebPushClient(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.ssl = builder.ssl;
        this.protocols = builder.protocols;
        this.handler = builder.handler;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public void connect() throws Exception {
        this.workerGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)this.workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.remoteAddress(this.host, this.port);
            b.handler((ChannelHandler)new WebPushClientInitializer(this.configureSsl(), this.host, this.port, this.handler));
            this.channel = b.connect().syncUninterruptibly().channel();
            System.out.println("Connected to [" + this.host + ':' + this.port + "][channelId=" + this.channel.id() + ']');
        }
        catch (Exception e) {
            e.printStackTrace();
            this.workerGroup.shutdownGracefully();
        }
    }

    public void register(String path) throws Exception {
        this.writeRequest(HttpMethod.POST, path, Unpooled.buffer());
    }

    public void monitor(String monitorUrl, boolean now) throws Exception {
        Http2Headers headers = this.http2Headers(HttpMethod.GET, monitorUrl);
        if (now) {
            headers.add(new AsciiString((CharSequence)"prefer"), new AsciiString((CharSequence)"wait=0"));
        }
        this.writeRequest(headers);
    }

    public void createSubscription(String subscribeUrl) throws Exception {
        this.writeRequest(HttpMethod.POST, subscribeUrl, Unpooled.buffer());
    }

    public void status(String endpointUrl) throws Exception {
        this.writeRequest(HttpMethod.GET, endpointUrl);
    }

    public void deleteSubscription(String endpointUrl) throws Exception {
        this.writeRequest(HttpMethod.DELETE, endpointUrl);
    }

    public void createAggregateSubscription(String aggregateUrl, String json) throws Exception {
        this.writeJsonRequest(HttpMethod.POST, aggregateUrl, Unpooled.copiedBuffer((CharSequence)json, (Charset)CharsetUtil.UTF_8));
    }

    public void notify(String endpointUrl, String payload) throws Exception {
        this.writeRequest(HttpMethod.PUT, endpointUrl, Unpooled.copiedBuffer((CharSequence)payload, (Charset)CharsetUtil.UTF_8));
    }

    private void writeRequest(HttpMethod method, String url) throws Exception {
        Http2Headers headers = this.http2Headers(method, url);
        this.writeRequest(headers);
    }

    private void writeRequest(Http2Headers headers) throws Exception {
        this.handler.outbound(headers);
        ChannelFuture requestFuture = this.channel.writeAndFlush((Object)new WebPushMessage(headers)).sync();
        requestFuture.sync();
    }

    private void writeRequest(HttpMethod method, String url, ByteBuf payload) throws Exception {
        Http2Headers headers = this.http2Headers(method, url);
        this.handler.outbound(headers);
        ChannelFuture requestFuture = this.channel.writeAndFlush((Object)new WebPushMessage(headers, payload)).sync();
        requestFuture.sync();
    }

    private void writeJsonRequest(HttpMethod method, String url, ByteBuf payload) throws Exception {
        Http2Headers headers = this.http2Headers(method, url);
        this.handler.outbound(headers, payload);
        ChannelFuture requestFuture = this.channel.writeAndFlush((Object)new WebPushMessage(headers, payload)).sync();
        requestFuture.sync();
    }

    private Http2Headers http2Headers(HttpMethod method, String url) {
        URI hostUri = URI.create("https://" + this.host + ":" + this.port + "/" + url);
        Http2Headers headers = new DefaultHttp2Headers(false).method(AsciiString.of((CharSequence)method.name()));
        headers.path(WebPushClient.asciiString(url));
        headers.authority(WebPushClient.asciiString(hostUri.getAuthority()));
        headers.scheme(WebPushClient.asciiString(hostUri.getScheme()));
        return headers;
    }

    private static AsciiString asciiString(String str) {
        return new AsciiString((CharSequence)str);
    }

    public void disconnect() {
        if (this.channel != null) {
            this.channel.close();
            this.shutdown();
        }
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public void shutdown() {
        this.workerGroup.shutdownGracefully();
    }

    private SslContext configureSsl() throws SSLException {
        if (this.ssl) {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.7")) {
                return SslContext.newClientContext((SslProvider)SslProvider.JDK, null, (TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE, null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, (ApplicationProtocolConfig)new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{Http2OrHttpChooser.SelectedProtocol.HTTP_2.protocolName(), Http2OrHttpChooser.SelectedProtocol.HTTP_1_1.protocolName()}), (long)0L, (long)0L);
            }
            return SslContext.newClientContext((SslProvider)SslProvider.JDK, null, (TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE, (Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, (ApplicationProtocolConfig)new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{Http2OrHttpChooser.SelectedProtocol.HTTP_2.protocolName(), Http2OrHttpChooser.SelectedProtocol.HTTP_1_1.protocolName()}), (long)0L, (long)0L);
        }
        return null;
    }

    public static Builder forHost(String host) {
        return new Builder(host);
    }

    public static class Builder {
        private final String host;
        private int port = 8443;
        private boolean ssl = true;
        private final List<String> protocols = new ArrayList<String>();
        private EventHandler handler;

        public Builder(String host) {
            this.host = host;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder port(String port) {
            this.port = Integer.parseInt(port);
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder notificationHandler(EventHandler handler) {
            this.handler = handler;
            return this;
        }

        public WebPushClient build() {
            if (this.protocols.isEmpty()) {
                this.protocols.add(Http2OrHttpChooser.SelectedProtocol.HTTP_2.protocolName());
                this.protocols.add(Http2OrHttpChooser.SelectedProtocol.HTTP_1_1.protocolName());
            }
            return new WebPushClient(this);
        }
    }
}

