/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import org.jboss.aerogear.webpush.AggregateSubscription;
import org.jboss.aerogear.webpush.EventHandler;
import org.jboss.aerogear.webpush.JsonMapper;
import org.jboss.aerogear.webpush.WebPushClient;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.AeshConsoleBuilder;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalString;

public class WebPushConsole {
    public static void main(String[] args) throws IOException {
        SettingsBuilder builder = new SettingsBuilder().logging(true);
        builder.enableMan(true).readInputrc(false);
        ConnectCommand connectCommand = new ConnectCommand();
        DisconnectCommand disconnectCommand = new DisconnectCommand(connectCommand);
        RegisterCommand registerCommand = new RegisterCommand(connectCommand);
        SubscribeCommand subscribeCommand = new SubscribeCommand(connectCommand);
        MonitorCommand monitorCommand = new MonitorCommand(connectCommand);
        NotifyCommand notifyCommand = new NotifyCommand(connectCommand);
        StatusCommand statusCommand = new StatusCommand(connectCommand);
        DeleteSubCommand deleteSubCommand = new DeleteSubCommand(connectCommand);
        AggregateCommand aggregateCommand = new AggregateCommand(connectCommand);
        Settings settings = builder.create();
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(ExitCommand.class).command((Command)connectCommand).command((Command)disconnectCommand).command((Command)registerCommand).command((Command)subscribeCommand).command((Command)monitorCommand).command((Command)notifyCommand).command((Command)statusCommand).command((Command)deleteSubCommand).command((Command)aggregateCommand).create();
        AeshConsole aeshConsole = new AeshConsoleBuilder().commandRegistry(registry).settings(settings).prompt(new Prompt(new TerminalString("[webpush]$ ", new TerminalColor(Color.GREEN, Color.DEFAULT, Color.Intensity.NORMAL)))).create();
        connectCommand.setConsole(aeshConsole);
        aeshConsole.start();
    }

    private static boolean isConnected(WebPushClient client, CommandInvocation inv) {
        if (client == null || !client.isConnected()) {
            inv.getShell().out().println("Please use the connect command to connect to the server");
            return false;
        }
        return true;
    }

    private static class CallbackHandler
    implements EventHandler {
        private final AeshConsole console;
        private final Prompt inbound = new Prompt(new TerminalString("< ", new TerminalColor(Color.YELLOW, Color.DEFAULT, Color.Intensity.BRIGHT)));
        private final Prompt outbound = new Prompt(new TerminalString("> ", new TerminalColor(Color.GREEN, Color.DEFAULT, Color.Intensity.BRIGHT)));

        CallbackHandler(AeshConsole console) {
            this.console = console;
        }

        @Override
        public void outbound(Http2Headers headers) {
            this.printOutbound(headers);
        }

        @Override
        public void outbound(Http2Headers headers, ByteBuf byteBuf) {
            this.printOutbound(headers, byteBuf);
        }

        @Override
        public void inbound(Http2Headers headers, int streamId) {
            this.printInbound(headers.toString(), streamId);
        }

        @Override
        public void notification(String data, int streamId) {
            this.printInbound(data, streamId);
        }

        @Override
        public void message(String message) {
            this.printOutbound(message);
        }

        private void printOutbound(Http2Headers headers) {
            this.printOutbound(headers.toString());
        }

        private void printOutbound(String msg) {
            Prompt current = this.console.getPrompt();
            this.console.setPrompt(this.outbound);
            this.console.getShell().out().println(msg);
            this.console.setPrompt(current);
        }

        private void printOutbound(Http2Headers headers, ByteBuf byteBuf) {
            Prompt current = this.console.getPrompt();
            this.console.setPrompt(this.outbound);
            this.console.getShell().out().println(headers.toString());
            this.console.getShell().out().println(JsonMapper.pretty(byteBuf.toString(CharsetUtil.UTF_8)));
            this.console.setPrompt(current);
        }

        private void printInbound(String message, int streamId) {
            Prompt current = this.console.getPrompt();
            this.console.setPrompt(this.inbound);
            this.console.getShell().out().println("[streamid:" + streamId + "] " + message);
            this.console.setPrompt(current);
        }
    }

    @CommandDefinition(name="aggregate", description="multiple channels so they are handled as one")
    public static class AggregateCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Option(hasValue=true, description="the aggreagate url from an earlier 'subscribe' commands location response", required=true)
        private String url;
        @Option(hasValue=true, description="comma separated list of channels that should be part of this aggreagate channel")
        private String channels;

        public AggregateCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("aggregate"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    String json = JsonMapper.toJson(AggregateSubscription.from(this.channels));
                    client.createAggregateSubscription(this.url, json);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="delete", description="subscription")
    public static class DeleteSubCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Option(hasValue=true, description="the endpoint url for the subscription to be deleted", required=true)
        private String url;

        public DeleteSubCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("delete"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    client.deleteSubscription(this.url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="status", description="of the subscription and returns the latest message if the server has any undelivered messages for the subscription")
    public static class StatusCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Option(hasValue=true, description="the endpoint url from an earlier 'subscribe' commands location response", required=true)
        private String url;

        public StatusCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("status"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    client.status(this.url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="notify", description="a channel")
    public static class NotifyCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Option(hasValue=true, description="the endpoint url from an earlier 'subscribe' commands location response", required=true)
        private String url;
        @Option(hasValue=true, description="the body/payload of the notification")
        private String payload;

        public NotifyCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("notify"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    client.notify(this.url, this.payload);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="monitor", description="for notifications")
    public static class MonitorCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Option(hasValue=true, description="the monitor WebLink URL, of rel type 'urn:ietf:params:push:reg',  from the register command response", required=true)
        private String url;
        @Option(hasValue=false, description="returns any existing notifications that the server might have")
        private boolean nowait;

        public MonitorCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("monitor"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    client.monitor(this.url, this.nowait);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="subscribe", description="and displays the endpoint-url for the created subscription")
    public static class SubscribeCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;
        @Option(hasValue=true, description="the subscription WebLink URL, of rel type 'urn:ietf:params:push:sub', from the register command response", required=true)
        private String url;

        public SubscribeCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("subscribe"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    client.createSubscription(this.url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="register", description="this device with the WebPush Server")
    public static class RegisterCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(shortName=112, hasValue=true, description="the path that that the WebPush server exposes for registrations", defaultValue={"/webpush/register"})
        private String path;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;

        public RegisterCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("register"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (!WebPushConsole.isConnected(client, commandInvocation)) {
                    return CommandResult.FAILURE;
                }
                try {
                    client.register(this.path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="disconnect", description="from the connected WebPush Server")
    public static class DisconnectCommand
    implements Command {
        private ConnectCommand connectCommand;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;

        public DisconnectCommand(ConnectCommand connectCommand) {
            this.connectCommand = connectCommand;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("disconnect"));
            } else {
                commandInvocation.putProcessInBackground();
                WebPushClient client = this.connectCommand.webPushClient();
                if (client != null && client.isConnected()) {
                    client.disconnect();
                    commandInvocation.getShell().out().println("Disconnected from [" + client.host() + ":" + client.port() + "]");
                } else {
                    commandInvocation.getShell().out().println("Not currently connected");
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="connect", description="<url>")
    public static class ConnectCommand
    implements Command {
        private WebPushClient webPushClient;
        private AeshConsole console;
        @Option(shortName=104, hasValue=true, description="the host to connect to", defaultValue={"localhost"})
        private String host;
        @Option(shortName=112, hasValue=true, description="the port to connect to", defaultValue={"8443"})
        private int port;
        @Option(hasValue=false, description="display this help and exit")
        private boolean help;

        public void setConsole(AeshConsole console) {
            this.console = console;
        }

        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            if (this.help) {
                commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("connect"));
            } else {
                if (this.webPushClient != null && this.webPushClient.isConnected()) {
                    commandInvocation.getShell().out().println("Currently connected. Will disconnect");
                    this.webPushClient.disconnect();
                }
                commandInvocation.putProcessInBackground();
                this.webPushClient = WebPushClient.forHost(this.host).port(this.port).ssl(true).notificationHandler(new CallbackHandler(this.console)).build();
                try {
                    this.webPushClient.connect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommandResult.FAILURE;
                }
            }
            return CommandResult.SUCCESS;
        }

        public WebPushClient webPushClient() {
            return this.webPushClient;
        }
    }

    @CommandDefinition(name="exit", description="the program")
    public static class ExitCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
            commandInvocation.stop();
            return CommandResult.SUCCESS;
        }
    }
}

