/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.choice;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCommand;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.extensions.choice.MultipleChoice;
import org.jboss.aesh.util.ANSI;

public class MultipleChoiceCommand
extends ConsoleCommand
implements Completion {
    private List<MultipleChoice> choices;
    private String commandName;
    private int rows;

    public MultipleChoiceCommand(Console console) {
        super(console);
    }

    public MultipleChoiceCommand(Console console, String commandName, List<MultipleChoice> choices) {
        super(console);
        this.commandName = commandName;
        this.choices = choices;
    }

    public List<MultipleChoice> getChoices() {
        return this.choices;
    }

    public void complete(CompleteOperation completeOperation) {
    }

    protected void afterAttach() throws IOException {
        this.rows = this.console.getTerminalSize().getHeight();
        this.console.pushToStdOut(ANSI.getAlternateBufferScreen());
        this.displayChoices();
    }

    private void displayChoices() throws IOException {
        this.console.clear();
        for (int i = 0; i < this.rows - this.choices.size() - 1; ++i) {
            this.console.pushToStdOut(Config.getLineSeparator());
        }
        for (MultipleChoice mc : this.choices) {
            if (mc.isChosen()) {
                this.console.pushToStdOut(mc.getId() + ") " + mc.getDisplayString() + " [X]" + Config.getLineSeparator());
                continue;
            }
            this.console.pushToStdOut(mc.getId() + ") " + mc.getDisplayString() + " [ ]" + Config.getLineSeparator());
        }
        this.console.pushToStdOut("Choose options: 1-" + this.choices.size() + ": ");
    }

    protected void afterDetach() throws IOException {
        this.console.pushToStdOut(ANSI.getMainBufferScreen());
    }

    public void processOperation(Operation operation) throws IOException {
        if (Character.isDigit(operation.getInput()[0])) {
            int c = Character.getNumericValue(operation.getInput()[0]);
            this.updateChoices(c);
            this.displayChoices();
        } else if (operation.getInput()[0] == 113) {
            this.detach();
        }
    }

    private void updateChoices(int id) {
        for (MultipleChoice c : this.choices) {
            if (c.getId() != id) continue;
            c.selectChoise();
        }
    }
}

