/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.manual.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.extensions.manual.parser.ManSection;
import org.jboss.aesh.extensions.page.PageLoader;

public class ManPageLoader
implements PageLoader {
    private List<ManSection> sections = new ArrayList<ManSection>();
    private String name;
    private String fileName;
    private String headerText;
    private InputStreamReader reader;

    public void setFile(String filename) throws IOException {
        this.setFile(new File(filename));
    }

    public void setFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " must be a file.");
        }
        if (file.getName().endsWith("gz")) {
            this.initGzReader(file);
        } else {
            this.initReader(file);
        }
        this.sections.clear();
    }

    public void setUrlFile(URL url) throws IOException {
        this.setFile(URLDecoder.decode(url.getFile(), Charset.defaultCharset().displayName()));
    }

    public void setFile(InputStream input, String fileName) throws IOException {
        if (input != null && fileName != null) {
            if (fileName.endsWith("gz")) {
                GZIPInputStream gzip = new GZIPInputStream(input);
                this.reader = new InputStreamReader(gzip);
            } else {
                this.reader = new InputStreamReader(input);
            }
            this.fileName = fileName;
        }
    }

    public void setFileFromAJar(String fileName) {
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is != null) {
            this.fileName = fileName;
            this.reader = new InputStreamReader(is);
        }
    }

    private void initReader(File file) throws FileNotFoundException {
        this.fileName = file.getAbsolutePath();
        this.reader = new FileReader(file);
    }

    private void initGzReader(File file) throws IOException {
        this.fileName = file.getAbsolutePath();
        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(file));
        this.reader = new InputStreamReader(gzip);
    }

    @Override
    public String getResourceName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> loadPage(int columns) throws IOException {
        if (!this.sections.isEmpty()) {
            return this.getAsList();
        }
        if (this.reader == null) {
            throw new IOException("InputStreamReader is null, cannot read file.");
        }
        BufferedReader br = new BufferedReader(this.reader);
        try {
            ManSection manSection;
            String line = br.readLine();
            boolean foundHeader = false;
            boolean foundEmptyLine = true;
            ArrayList<String> section = new ArrayList<String>();
            while (line != null) {
                if (line.trim().isEmpty() && !foundEmptyLine) {
                    foundEmptyLine = true;
                    section.add(line);
                } else if (line.isEmpty() && foundEmptyLine) {
                    if (!foundHeader) {
                        this.processHeader(section, columns);
                        foundHeader = true;
                    } else {
                        manSection = new ManSection().parseSection(section, columns);
                        this.sections.add(manSection);
                    }
                    foundEmptyLine = false;
                    section.clear();
                } else {
                    if (foundEmptyLine) {
                        foundEmptyLine = false;
                    }
                    section.add(line);
                }
                line = br.readLine();
            }
            if (!section.isEmpty()) {
                manSection = new ManSection().parseSection(section, columns);
                this.sections.add(manSection);
            }
            List<String> list = this.getAsList();
            return list;
        }
        finally {
            br.close();
        }
    }

    private void processHeader(List<String> header, int columns) throws IOException {
        if (header.size() != 4) {
            throw new IOException("File did not include the correct header.");
        }
        this.name = header.get(0);
        if (!header.get(2).equals(":doctype: manpage")) {
            throw new IOException("File did not include the correct header: \":doctype: manpage\"");
        }
    }

    public List<ManSection> getSections() {
        return this.sections;
    }

    public List<String> getAsList() {
        ArrayList<String> out = new ArrayList<String>();
        for (ManSection section : this.sections) {
            out.addAll(section.getAsList());
        }
        return out;
    }

    public String print() {
        StringBuilder builder = new StringBuilder();
        for (ManSection section : this.sections) {
            builder.append(section.printToTerminal()).append(Config.getLineSeparator());
        }
        return builder.toString();
    }
}

