/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.more;

import java.io.File;
import java.io.IOException;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCommand;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.extensions.page.Page;
import org.jboss.aesh.extensions.page.PageLoader;
import org.jboss.aesh.extensions.page.SimplePageLoader;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.FileLister;
import org.jboss.aesh.util.Parser;

public class More
extends ConsoleCommand
implements Completion {
    private int rows;
    private int topVisibleRow;
    private int prevTopVisibleRow;
    private StringBuilder number;
    private MorePage page;
    private SimplePageLoader loader = new SimplePageLoader();

    public More(Console console) {
        super(console);
        this.number = new StringBuilder();
    }

    public void setFile(File page) throws IOException {
        this.loader.setFile(page);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(new File(filename));
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    protected void afterAttach() throws IOException {
        this.rows = this.console.getTerminalSize().getHeight();
        int columns = this.console.getTerminalSize().getWidth();
        this.page = new MorePage(this.loader, columns);
        if (ControlOperator.isRedirectionOut((ControlOperator)this.getConsoleOutput().getControlOperator())) {
            int count = 0;
            for (String line : this.page.getLines()) {
                this.console.pushToStdOut(line);
                if (++count >= this.page.size()) continue;
                this.console.pushToStdOut(Config.getLineSeparator());
            }
            this.detach();
        } else if (this.page.hasData()) {
            this.display(Background.INVERSE);
        }
    }

    protected void afterDetach() throws IOException {
        this.clearNumber();
        this.prevTopVisibleRow = 0;
        this.topVisibleRow = 0;
        if (!ControlOperator.isRedirectionOut((ControlOperator)this.getConsoleOutput().getControlOperator())) {
            this.console.pushToStdOut(Buffer.printAnsi((String)"K"));
            this.console.pushToStdOut(Buffer.printAnsi((String)"1G"));
        }
        this.page.clear();
    }

    public void processOperation(Operation operation) throws IOException {
        if (operation.getInput()[0] == 113) {
            this.detach();
        } else if (operation.equals((Object)Operation.NEW_LINE)) {
            this.topVisibleRow += this.getNumber();
            if (this.topVisibleRow > this.page.size() - this.rows) {
                this.topVisibleRow = this.page.size() - this.rows;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display(Background.INVERSE);
                this.detach();
            } else {
                this.display(Background.INVERSE);
            }
            this.clearNumber();
        } else if (operation.getInput()[0] == 6 || operation.getInput()[0] == 32) {
            this.topVisibleRow += this.rows * this.getNumber();
            if (this.topVisibleRow > this.page.size() - this.rows) {
                this.topVisibleRow = this.page.size() - this.rows;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display(Background.INVERSE);
                this.detach();
            } else {
                this.display(Background.INVERSE);
            }
            this.clearNumber();
        } else if (operation.getInput()[0] == 2) {
            this.topVisibleRow -= this.rows * this.getNumber();
            if (this.topVisibleRow < 0) {
                this.topVisibleRow = 0;
            }
            this.display(Background.INVERSE);
            this.clearNumber();
        } else if (Character.isDigit(operation.getInput()[0])) {
            this.number.append(Character.getNumericValue(operation.getInput()[0]));
        }
    }

    private void display(Background background) throws IOException {
        this.console.pushToStdOut(Buffer.printAnsi((String)"0G"));
        this.console.pushToStdOut(Buffer.printAnsi((String)"2K"));
        if (this.prevTopVisibleRow == 0 && this.topVisibleRow == 0) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.console.pushToStdOut(this.page.getLine(i));
                this.console.pushToStdOut(Config.getLineSeparator());
            }
        } else if (this.prevTopVisibleRow < this.topVisibleRow) {
            for (int i = this.prevTopVisibleRow; i < this.topVisibleRow; ++i) {
                this.console.pushToStdOut(this.page.getLine(i + this.rows));
                this.console.pushToStdOut(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        } else if (this.prevTopVisibleRow > this.topVisibleRow) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.console.pushToStdOut(this.page.getLine(i));
                this.console.pushToStdOut(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        }
        this.displayBottom(background);
    }

    private void displayBottom(Background background) throws IOException {
        if (background == Background.INVERSE) {
            this.console.pushToStdOut(ANSI.getInvertedBackground());
            this.console.pushToStdOut("--More--(");
            this.console.pushToStdOut(this.getPercentDisplayed() + "%)");
            this.console.pushToStdOut(ANSI.getNormalBackground());
        }
    }

    private String getPercentDisplayed() {
        double row = this.topVisibleRow + this.rows;
        if (row > (double)this.page.size()) {
            row = this.page.size();
        }
        return String.valueOf((int)(row / (double)this.page.size() * 100.0));
    }

    public void complete(CompleteOperation completeOperation) {
        if (completeOperation.getBuffer().equals("m")) {
            completeOperation.getCompletionCandidates().add("more");
        } else if (completeOperation.getBuffer().equals("mo")) {
            completeOperation.getCompletionCandidates().add("more");
        } else if (completeOperation.getBuffer().equals("mor")) {
            completeOperation.getCompletionCandidates().add("more");
        } else if (completeOperation.getBuffer().equals("more")) {
            completeOperation.getCompletionCandidates().add("more");
        } else if (completeOperation.getBuffer().startsWith("more ")) {
            String word = Parser.findWordClosestToCursor((String)completeOperation.getBuffer(), (int)completeOperation.getCursor());
            completeOperation.setOffset(completeOperation.getCursor());
            new FileLister(word, new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
        }
    }

    public void displayHelp() throws IOException {
        this.console.pushToStdOut(Config.getLineSeparator() + "Usage: more [options] file..." + Config.getLineSeparator());
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private class MorePage
    extends Page {
        public MorePage(PageLoader loader, int columns) {
            super(loader, columns);
        }
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

