/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.grep;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.cl.completer.CompleterData;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandInvocation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.util.FileLister;

@CommandDefinition(name="grep", description="[OPTION]... PATTERN [FILE]...\nSearch for PATTERN in each FILE or standard input.\nPATTERN is, by default, a basic regular expression (BRE).\nExample: grep -i 'hello world' menu.h main.c\n")
public class Grep
implements Command {
    @Option(shortName=72, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=69, name="extended-regexp", hasValue=false, description="PATTERN is an extended regular expression (ERE)")
    private boolean extendedRegex;
    @Option(shortName=70, name="fixed-strings", hasValue=false, description="PATTERN is a set of newline-separated fixed strings")
    private boolean fixedStrings;
    @Option(shortName=71, name="basic-regexp", hasValue=false, description="PATTERN is a basic regular expression (BRE)")
    private boolean basicRegexp;
    @Option(shortName=80, name="perl-regexp", hasValue=false, description="PATTERN is a Perl regular expression")
    private boolean perlRegexp;
    @Option(shortName=101, name="regexp", argument="PATTERN", description="use PATTERN for matching")
    private String regexp;
    @Option(shortName=102, name="file", argument="FILE", description="obtain PATTERN from FILE")
    private File file;
    @Option(shortName=105, name="ignore-case", hasValue=false, description="ignore case distinctions")
    private boolean ignoreCase;
    @Arguments(completer=GrepCompletor.class)
    private List<String> arguments;
    private String pattern;

    public List<String> getArguments() {
        return this.arguments;
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        if (this.help) {
            commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("grep"));
            return CommandResult.SUCCESS;
        }
        if (commandInvocation.in().getStdIn().available() > 0) {
            Scanner s = new Scanner(commandInvocation.in().getStdIn()).useDelimiter("\\A");
            String input = s.hasNext() ? s.next() : "";
            ArrayList<String> inputLines = new ArrayList<String>();
            for (String i : input.split("\n")) {
                inputLines.add(i);
            }
            if (this.arguments != null && this.arguments.size() > 0) {
                this.pattern = this.arguments.remove(0);
            }
            this.doGrep(inputLines, commandInvocation.getShell());
        } else {
            if (this.arguments != null && this.arguments.size() > 0) {
                this.pattern = this.arguments.remove(0);
            }
            if (this.arguments != null && this.arguments.size() > 0) {
                for (String s : this.arguments) {
                    this.doGrep(new File(s), commandInvocation.getShell());
                }
            } else {
                return CommandResult.SUCCESS;
            }
        }
        return null;
    }

    private void doGrep(File file, Shell shell) {
        if (!file.exists()) {
            shell.out().println("grep: " + file.toString() + ": No such file or directory");
        } else if (file.isFile()) {
            try {
                String line;
                FileReader fileReader = new FileReader(file);
                BufferedReader br = new BufferedReader(fileReader);
                ArrayList<String> inputLines = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    inputLines.add(line);
                }
                this.doGrep(inputLines, shell);
            }
            catch (FileNotFoundException fnf) {
                fnf.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void doGrep(List<String> inputLines, Shell shell) {
        if (this.pattern != null) {
            for (String line : inputLines) {
                if (line == null || !line.contains(this.pattern)) continue;
                shell.out().println(line);
            }
        } else {
            shell.out().println("No pattern given");
        }
    }

    public static class GrepCompletor
    implements OptionCompleter {
        public void complete(CompleterData completerData) {
            Grep grep = (Grep)completerData.getCommand();
            if (grep.getArguments() == null || grep.getArguments().size() == 0) {
                return;
            }
            if (grep.getArguments().size() > 0) {
                File cwd = new File(Config.getUserDir());
                CompleteOperation completeOperation = new CompleteOperation(completerData.getGivenCompleteValue(), 0);
                if (completerData.getGivenCompleteValue() == null) {
                    new FileLister("", cwd, FileLister.Filter.ALL).findMatchingDirectories(completeOperation);
                } else {
                    new FileLister(completerData.getGivenCompleteValue(), cwd, FileLister.Filter.ALL).findMatchingDirectories(completeOperation);
                }
                if (completeOperation.getCompletionCandidates().size() > 1) {
                    completeOperation.removeEscapedSpacesFromCompletionCandidates();
                }
                completerData.setCompleterValues(completeOperation.getCompletionCandidates());
                if (completerData.getGivenCompleteValue() != null && completerData.getCompleterValues().size() == 1) {
                    completerData.setAppendSpace(completeOperation.hasAppendSeparator());
                }
            }
        }
    }
}

