/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.less.aesh;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.CommandInvocation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.ConsoleCommand;
import org.jboss.aesh.extensions.page.AeshFileDisplayer;
import org.jboss.aesh.extensions.page.Page;
import org.jboss.aesh.extensions.page.PageLoader;
import org.jboss.aesh.extensions.page.SimplePageLoader;
import org.jboss.aesh.util.ANSI;

@CommandDefinition(name="less", description="less is more")
public class Less
extends AeshFileDisplayer {
    @Arguments
    List<File> arguments;
    private SimplePageLoader loader;

    public void setFile(File file) throws IOException {
        this.loader.setFile(file);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(filename);
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    @Override
    public PageLoader getPageLoader() {
        return this.loader;
    }

    @Override
    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == Page.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == Page.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.getInvertedBackground() + "Pattern not found (press RETURN)" + ANSI.defaultText());
        } else if (this.getSearchStatus() == Page.Search.RESULT) {
            this.writeToConsole(":");
        } else if (this.getSearchStatus() == Page.Search.NO_SEARCH) {
            if (this.isAtBottom()) {
                this.writeToConsole(ANSI.getInvertedBackground() + "(END)" + ANSI.defaultText());
            } else {
                this.writeToConsole(":");
            }
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        this.setCommandInvocation(commandInvocation);
        this.loader = new SimplePageLoader();
        if (commandInvocation.in().getStdIn().available() > 0) {
            Scanner s = new Scanner(commandInvocation.in().getStdIn()).useDelimiter("\\A");
            String fileContent = s.hasNext() ? s.next() : "";
            this.setInput(fileContent);
            this.getCommandInvocation().attachConsoleCommand((ConsoleCommand)this);
            this.afterAttach();
        } else if (this.arguments != null && this.arguments.size() > 0) {
            File f = this.arguments.get(0);
            if (f.isFile()) {
                this.setFile(f);
                this.getCommandInvocation().attachConsoleCommand((ConsoleCommand)this);
                this.afterAttach();
            } else if (f.isDirectory()) {
                this.getShell().err().println(f.getAbsolutePath() + ": is a directory");
            } else {
                this.getShell().err().println(f.getAbsolutePath() + ": No such file or directory");
            }
        }
        return CommandResult.SUCCESS;
    }
}

