/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.ls;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandInvocation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.extensions.ls.StringGroup;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Shell;

@CommandDefinition(name="ls", description="[OPTION]... [FILE]...\nList information about the FILEs (the current directory by default).\nSort entries alphabetically if none of -cftuvSUX nor --sort is specified.\n")
public class Ls
implements Command {
    @Option(shortName=72, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=97, name="all", hasValue=false, description="do not ignore entries starting with .")
    private boolean all;
    @Option(shortName=100, name="directory", hasValue=false, description="list directory entries instead of contents, and do not dereference symbolic links")
    private boolean directory;
    @Option(shortName=108, name="longlisting", hasValue=false, description="use a long listing format")
    private boolean longListing;
    @Option(shortName=115, name="size", hasValue=false, description="print the allocated size of each file, in blocks")
    private boolean size;
    @Arguments
    private List<File> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        if (this.help) {
            commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("ls"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList<File>(1);
            this.arguments.add(new File("/tmp"));
        }
        for (File f : this.arguments) {
            if (f.isDirectory()) {
                this.displayDirectory(f, commandInvocation.getShell());
                continue;
            }
            if (f.isFile()) {
                this.displayFile(f, commandInvocation.getShell());
                continue;
            }
            if (f.exists()) continue;
            commandInvocation.getShell().out().println("ls: cannot access " + f.toString() + ": No such file or directory");
        }
        return CommandResult.SUCCESS;
    }

    private void displayDirectory(File input, Shell shell) {
        if (this.longListing) {
            shell.out().println(this.displayLongListing(input.listFiles()));
        } else {
            shell.out().println(Parser.formatDisplayList((String[])input.list(), (int)shell.getSize().getHeight(), (int)shell.getSize().getWidth()));
        }
    }

    private void displayFile(File input, Shell shell) {
    }

    private String displayLongListing(File[] files) {
        StringGroup access = this.getAccessString(files);
        StringGroup size = this.getSize(files);
        StringGroup owner = this.getOwner(files);
        StringGroup group = this.getGroup(files);
        StringGroup modified = this.getModified(files);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            builder.append(access.getString(i)).append(size.getString(i)).append(owner.getString(i)).append(group.getString(i)).append(modified.getString(i)).append(" ").append(files[i].getName()).append(Config.getLineSeparator());
        }
        return builder.toString();
    }

    private StringGroup getAccessString(File[] files) {
        StringGroup access = new StringGroup(files.length);
        int counter = 0;
        for (File file : files) {
            StringBuilder builder = new StringBuilder();
            if (file.isDirectory()) {
                builder.append("d");
            } else {
                builder.append("-");
            }
            if (file.canRead()) {
                builder.append("r");
            } else {
                builder.append("-");
            }
            if (file.canWrite()) {
                builder.append("w");
            } else {
                builder.append("-");
            }
            if (file.canExecute()) {
                builder.append("x");
            } else {
                builder.append("-");
            }
            access.addString(builder.toString(), counter++);
        }
        access.formatStringsBasedOnMaxLength();
        return access;
    }

    private StringGroup getSize(File[] files) {
        StringGroup size = new StringGroup(files.length);
        int counter = 0;
        for (File file : files) {
            size.addString("1", counter++);
        }
        size.formatStringsBasedOnMaxLength();
        return size;
    }

    private StringGroup getOwner(File[] files) {
        StringGroup owner = new StringGroup(files.length);
        int counter = 0;
        for (File file : files) {
            owner.addString("owner", counter++);
        }
        owner.formatStringsBasedOnMaxLength();
        return owner;
    }

    private StringGroup getGroup(File[] files) {
        StringGroup group = new StringGroup(files.length);
        int counter = 0;
        for (File file : files) {
            group.addString("group", counter++);
        }
        group.formatStringsBasedOnMaxLength();
        return group;
    }

    private StringGroup getModified(File[] files) {
        StringGroup modified = new StringGroup(files.length);
        int counter = 0;
        for (File file : files) {
            modified.addString(new Date(file.lastModified()).toString(), counter++);
        }
        modified.formatStringsBasedOnMaxLength();
        return modified;
    }
}

