/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.page;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandInvocation;
import org.jboss.aesh.console.command.ConsoleCommand;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.extensions.less.LessPage;
import org.jboss.aesh.extensions.page.Page;
import org.jboss.aesh.extensions.page.PageLoader;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.LoggerUtil;

public abstract class AeshFileDisplayer
implements ConsoleCommand,
Command {
    private int rows;
    private int columns;
    private int topVisibleRow;
    private int topVisibleRowCache;
    private LessPage page;
    private StringBuilder number;
    private Page.Search search = Page.Search.NO_SEARCH;
    private StringBuilder searchBuilder;
    private List<Integer> searchLines;
    private Logger logger = LoggerUtil.getLogger((String)this.getClass().getName());
    private CommandInvocation commandInvocation;
    private ControlOperator operation;
    private boolean attached = true;

    protected void setCommandInvocation(CommandInvocation commandInvocation) {
        this.commandInvocation = commandInvocation;
        this.setControlOperator(commandInvocation.getControlOperator());
    }

    protected CommandInvocation getCommandInvocation() {
        return this.commandInvocation;
    }

    protected void setControlOperator(ControlOperator operator) {
        this.operation = operator;
    }

    protected Shell getShell() {
        return this.commandInvocation.getShell();
    }

    protected void afterAttach() throws IOException {
        this.attached = true;
        this.number = new StringBuilder();
        this.searchBuilder = new StringBuilder();
        this.rows = this.getShell().getSize().getHeight();
        this.columns = this.getShell().getSize().getWidth();
        this.page = new LessPage(this.getPageLoader(), this.columns);
        this.topVisibleRow = 0;
        this.topVisibleRowCache = -1;
        if (this.operation.isRedirectionOut()) {
            int count = 0;
            for (String line : this.page.getLines()) {
                this.getShell().out().print(line);
                if (++count >= this.page.size()) continue;
                this.getShell().out().print(Config.getLineSeparator());
            }
            this.getShell().out().flush();
            this.afterDetach();
        } else if (!this.page.hasData()) {
            this.getShell().out().print("Missing filename (\"less --help\" for help)\n");
            this.afterDetach();
        } else {
            this.getShell().out().print(ANSI.getAlternateBufferScreen());
            if (this.page.getFileName() != null) {
                this.display();
            } else {
                this.display();
            }
        }
        this.getShell().out().flush();
    }

    protected void afterDetach() throws IOException {
        if (!this.operation.isRedirectionOut()) {
            this.getShell().out().print(ANSI.getMainBufferScreen());
        }
        this.page.clear();
        this.topVisibleRow = 0;
        this.attached = false;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void processOperation(Operation operation) throws IOException {
        if (operation.getInput()[0] == 113) {
            if (this.search == Page.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else {
                this.clearNumber();
                this.afterDetach();
            }
        } else if (operation.getInput()[0] == 106 || operation.equals((Object)Operation.HISTORY_NEXT) || operation.equals((Object)Operation.NEW_LINE)) {
            if (this.search == Page.Search.SEARCHING) {
                if (operation.getInput()[0] == 106) {
                    this.searchBuilder.append((char)operation.getInput()[0]);
                    this.displayBottom();
                } else if (operation.equals((Object)Operation.NEW_LINE)) {
                    this.search = Page.Search.RESULT;
                    this.findSearchWord(true);
                }
            } else {
                this.topVisibleRow += this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (operation.getInput()[0] == 107 || operation.equals((Object)Operation.HISTORY_PREV)) {
            if (this.search == Page.Search.SEARCHING) {
                if (operation.getInput()[0] == 107) {
                    this.searchBuilder.append((char)operation.getInput()[0]);
                }
                this.displayBottom();
            } else {
                this.topVisibleRow -= this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (operation.getInput()[0] == 6 || operation.equals((Object)Operation.PGDOWN) || operation.getInput()[0] == 32) {
            if (this.search != Page.Search.SEARCHING) {
                this.topVisibleRow = this.topVisibleRow + this.rows * this.getNumber() - 1;
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (operation.getInput()[0] == 2 || operation.equals((Object)Operation.PGUP)) {
            if (this.search != Page.Search.SEARCHING) {
                this.topVisibleRow = this.topVisibleRow - this.rows * this.getNumber() - 1;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (operation.getInput()[0] == 47) {
            if (this.search == Page.Search.NO_SEARCH || this.search == Page.Search.RESULT) {
                this.search = Page.Search.SEARCHING;
                this.searchBuilder = new StringBuilder();
                this.displayBottom();
            } else if (this.search == Page.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            }
        } else if (operation.getInput()[0] == 110) {
            if (this.search == Page.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else if (this.search == Page.Search.RESULT) {
                if (this.searchLines.size() > 0) {
                    for (Integer i : this.searchLines) {
                        if (i <= this.topVisibleRow + 1) continue;
                        this.topVisibleRow = i - 1;
                        this.display();
                        return;
                    }
                    this.displayBottom();
                } else {
                    this.displayBottom();
                }
            }
        } else if (operation.getInput()[0] == 78) {
            if (this.search == Page.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else if (this.search == Page.Search.RESULT && this.searchLines.size() > 0) {
                for (int i = this.searchLines.size() - 1; i >= 0; --i) {
                    if (this.searchLines.get(i) >= this.topVisibleRow) continue;
                    this.topVisibleRow = this.searchLines.get(i) - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                    return;
                }
                this.displayBottom();
            }
        } else if (operation.getInput()[0] == 71) {
            if (this.search == Page.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else {
                if (this.number.length() == 0 || this.getNumber() == 0) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    this.display();
                } else {
                    this.topVisibleRow = this.getNumber() - 1;
                    if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                        this.topVisibleRow = this.page.size() - this.rows - 1;
                        this.display();
                    } else {
                        this.display();
                    }
                }
                this.clearNumber();
            }
        } else if (Character.isDigit(operation.getInput()[0])) {
            if (this.search == Page.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else {
                this.number.append(Character.getNumericValue(operation.getInput()[0]));
                this.display();
            }
        } else if (this.search == Page.Search.SEARCHING && Character.isAlphabetic(operation.getInput()[0])) {
            this.searchBuilder.append((char)operation.getInput()[0]);
            this.displayBottom();
        }
    }

    private void display() throws IOException {
        if (this.topVisibleRow != this.topVisibleRowCache) {
            this.getShell().clear();
            if (this.search == Page.Search.RESULT && this.searchLines.size() > 0) {
                String searchWord = this.searchBuilder.toString();
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    String line = this.page.getLine(i);
                    if (line.contains(searchWord)) {
                        this.displaySearchLine(line, searchWord);
                    } else {
                        this.getShell().out().print(line);
                    }
                    this.getShell().out().print(Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            } else {
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    this.getShell().out().print(this.page.getLine(i) + Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            }
            this.displayBottom();
        }
        this.getShell().out().flush();
    }

    private void displaySearchLine(String line, String searchWord) throws IOException {
        int start = line.indexOf(searchWord);
        this.getShell().out().print(line.substring(0, start));
        this.getShell().out().print(ANSI.getInvertedBackground());
        this.getShell().out().print(searchWord);
        this.getShell().out().print(ANSI.reset());
        this.getShell().out().print(line.substring(start + searchWord.length(), line.length()));
        this.getShell().out().flush();
    }

    public abstract PageLoader getPageLoader();

    public abstract void displayBottom() throws IOException;

    public void writeToConsole(String word) throws IOException {
        this.getShell().out().print(word);
        this.getShell().out().flush();
    }

    public void clearBottomLine() throws IOException {
        this.getShell().out().print(Buffer.printAnsi((String)"0G"));
        this.getShell().out().print(Buffer.printAnsi((String)"2K"));
        this.getShell().out().flush();
    }

    public boolean isAtBottom() {
        return this.topVisibleRow >= this.page.size() - this.rows - 1;
    }

    public boolean isAtTop() {
        return this.topVisibleRow == 0;
    }

    public Page.Search getSearchStatus() {
        return this.search;
    }

    public String getSearchWord() {
        return this.searchBuilder.toString();
    }

    public int getTopVisibleRow() {
        return this.topVisibleRow + 1;
    }

    private void findSearchWord(boolean forward) throws IOException {
        this.logger.info("searching for: " + this.searchBuilder.toString());
        this.searchLines = this.page.findWord(this.searchBuilder.toString());
        this.logger.info("found: " + this.searchLines);
        if (this.searchLines.size() > 0) {
            for (Integer i : this.searchLines) {
                if (i <= this.topVisibleRow) continue;
                this.topVisibleRow = i - 1;
                this.display();
                return;
            }
        } else {
            this.search = Page.Search.NOT_FOUND;
            this.displayBottom();
        }
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

