/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.less.console;

import java.io.File;
import java.io.IOException;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.extensions.page.FileDisplayer;
import org.jboss.aesh.extensions.page.SimpleFileParser;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.FileLister;

public class Less
extends FileDisplayer {
    private SimpleFileParser loader;

    public Less(Console console) {
        this.setConsole(console);
        this.loader = new SimpleFileParser();
    }

    public void setFile(File file) throws IOException {
        this.loader.setFile(file);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(filename);
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    @Override
    public FileParser getFileParser() {
        return this.loader;
    }

    public void complete(CompleteOperation completeOperation) {
        if ("less".startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate("less");
        } else if (completeOperation.getBuffer().startsWith("less ")) {
            String word = Parser.findWordClosestToCursor((String)completeOperation.getBuffer(), (int)completeOperation.getCursor());
            completeOperation.setOffset(completeOperation.getCursor());
            new FileLister(word, new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
        }
    }

    @Override
    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.getInvertedBackground() + "Pattern not found (press RETURN)" + ANSI.defaultText());
        } else if (this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(":");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH) {
            if (this.isAtBottom()) {
                this.writeToConsole(ANSI.getInvertedBackground() + "(END)" + ANSI.defaultText());
            } else {
                this.writeToConsole(":");
            }
        }
    }
}

