/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.choice.aesh;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.ConsoleCommand;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.LoggerUtil;

public class MultipleChoice
implements ConsoleCommand,
Completion {
    private List<org.jboss.aesh.extensions.choice.console.MultipleChoice> choices;
    private String commandName;
    private int rows;
    private Console console;
    private boolean attached = true;
    private Logger logger = LoggerUtil.getLogger((String)MultipleChoice.class.getName());

    public MultipleChoice(Console console) {
        this.console = console;
    }

    public MultipleChoice(Console console, String commandName, List<org.jboss.aesh.extensions.choice.console.MultipleChoice> choices) {
        this.console = console;
        this.commandName = commandName;
        this.choices = choices;
    }

    public List<org.jboss.aesh.extensions.choice.console.MultipleChoice> getChoices() {
        return this.choices;
    }

    public void complete(CompleteOperation completeOperation) {
    }

    public boolean isAttached() {
        return this.attached;
    }

    protected void afterAttach() throws IOException {
        this.rows = this.console.getTerminalSize().getHeight();
        this.console.getShell().out().print(ANSI.getAlternateBufferScreen());
        this.logger.info("printed out alternateBufferScreen");
        this.displayChoices();
    }

    private void displayChoices() throws IOException {
        this.console.clear();
        for (int i = 0; i < this.rows - this.choices.size() - 1; ++i) {
            this.console.getShell().out().print(Config.getLineSeparator());
        }
        for (org.jboss.aesh.extensions.choice.console.MultipleChoice mc : this.choices) {
            if (mc.isChosen()) {
                this.console.getShell().out().print(mc.getId() + ") " + mc.getDisplayString() + " [X]" + Config.getLineSeparator());
                continue;
            }
            this.console.getShell().out().print(mc.getId() + ") " + mc.getDisplayString() + " [ ]" + Config.getLineSeparator());
        }
        this.console.getShell().out().print("Choose options: 1-" + this.choices.size() + ": ");
        this.console.getShell().out().flush();
    }

    protected void afterDetach() throws IOException {
        this.console.getShell().out().print(ANSI.getMainBufferScreen());
        this.attached = false;
    }

    public void processOperation(CommandOperation operation) throws IOException {
        if (Character.isDigit(operation.getInput()[0])) {
            int c = Character.getNumericValue(operation.getInput()[0]);
            this.console.getShell().out().print("got " + c + "\n");
            this.updateChoices(c);
            this.displayChoices();
        } else if (operation.getInput()[0] == 113) {
            this.afterDetach();
        }
    }

    private void updateChoices(int id) {
        for (org.jboss.aesh.extensions.choice.console.MultipleChoice c : this.choices) {
            if (c.getId() != id) continue;
            c.selectChoise();
        }
    }
}

