/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.harlem.console;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.ConsoleCommand;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.util.ANSI;

public class Harlem
implements ConsoleCommand,
Completion {
    private int rows;
    private int columns;
    private char[] randomChars = new char[]{'@', '#', '$', '%', '&', '{', '}', '?', '-', '/', '\\'};
    private Color[] randomColors = new Color[]{Color.GREEN, Color.BLUE, Color.RED, Color.YELLOW, Color.DEFAULT};
    private Random random;
    private TerminalCharacter[][] terminalCharacters;
    private boolean allowDownload = false;
    private File harlemWav = new File(Config.getTmpDir() + Config.getPathSeparator() + "harlem.wav");
    private Console console;
    private boolean attached = true;

    public Harlem(Console console) {
        this.console = console;
        this.random = new Random();
    }

    public void afterAttach() throws IOException {
        this.rows = this.console.getTerminalSize().getHeight();
        this.columns = this.console.getTerminalSize().getWidth();
        this.terminalCharacters = new TerminalCharacter[this.rows][this.columns];
        this.console.getShell().out().print(ANSI.getAlternateBufferScreen());
        if (!this.harlemWav.isFile()) {
            this.displayQuestion();
        } else {
            this.startHarlem();
        }
    }

    public boolean isAttached() {
        return this.attached;
    }

    private void displayQuestion() throws IOException {
        this.console.getShell().out().print(ANSI.getStart() + this.rows + ";1H");
        this.console.getShell().out().print("Allow harlem to save file to \"" + Config.getTmpDir() + "? (y or n)");
        this.console.getShell().out().flush();
    }

    protected void afterDetach() throws IOException {
        this.console.getShell().out().print(ANSI.getMainBufferScreen());
        this.console.getShell().out().print(ANSI.getStart() + "?25h");
        this.console.getShell().out().flush();
        this.attached = false;
    }

    private void displayWait() throws IOException {
        this.console.getShell().out().print(ANSI.getStart() + "?25l");
        this.console.getShell().out().print(ANSI.getStart() + this.rows / 2 + ";1H");
        this.console.getShell().out().print("Buffering....  please wait.....");
        this.console.getShell().out().flush();
    }

    private void displayIntro() throws IOException {
        int i;
        this.console.getShell().out().print(ANSI.getStart() + "1;1H");
        TerminalCharacter startChar = new TerminalCharacter('|');
        for (i = 0; i < this.terminalCharacters.length; ++i) {
            for (int j = 0; j < this.terminalCharacters[i].length; ++j) {
                this.terminalCharacters[i][j] = startChar;
            }
        }
        for (i = 0; i < this.terminalCharacters.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.terminalCharacters[i].length; ++j) {
                if (j > 0) {
                    sb.append(this.terminalCharacters[i][j].toString(this.terminalCharacters[i][j]));
                    continue;
                }
                sb.append(this.terminalCharacters[i][j].toString());
            }
            this.console.getShell().out().print(sb.toString());
        }
        this.console.getShell().out().flush();
        int middleRow = this.rows / 2;
        int middleColumn = this.columns / 2;
        TerminalCharacter middleChar = this.terminalCharacters[middleRow][middleColumn];
        for (int i2 = 0; i2 < 33; ++i2) {
            try {
                Thread.sleep(450L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.console.getShell().out().print(ANSI.getStart() + middleRow + ";" + middleColumn + "H");
            this.console.getShell().out().print(middleChar.toString());
            this.console.getShell().out().flush();
            middleChar = new TerminalCharacter(this.getNextChar(middleChar.getCharacter()));
        }
        this.displayHarlem();
    }

    private char getNextChar(char prev) {
        if (prev == '|') {
            return '/';
        }
        if (prev == '/') {
            return '-';
        }
        if (prev == '-') {
            return '\\';
        }
        return '|';
    }

    private char getRandomChar() {
        return this.randomChars[this.random.nextInt(this.randomChars.length)];
    }

    private Color getRandomColor() {
        return this.randomColors[this.random.nextInt(this.randomColors.length)];
    }

    private void displayHarlem() throws IOException {
        for (int i = 0; i < 22; ++i) {
            try {
                Thread.sleep(630L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.displayCorus();
        }
    }

    private void displayCorus() throws IOException {
        this.console.getShell().out().print(ANSI.getStart() + "1;1H");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.terminalCharacters.length; ++i) {
            for (int j = 0; j < this.terminalCharacters[i].length; ++j) {
                if (j % 2 == 0) {
                    sb.append(new TerminalCharacter(' ').toString());
                    continue;
                }
                sb.append(new TerminalCharacter(this.getRandomChar(), new TerminalColor(this.getRandomColor(), Color.DEFAULT)).toString());
            }
        }
        this.console.getShell().out().print(sb.toString());
        this.console.getShell().out().flush();
    }

    public void processOperation(CommandOperation operation) throws IOException {
        if (operation.getInput()[0] == 121) {
            this.allowDownload = true;
            this.startHarlem();
        }
        if (operation.getInput()[0] == 110) {
            this.startHarlem();
        }
        if (operation.getInput()[0] == 113) {
            this.afterDetach();
        }
    }

    private void startHarlem() throws IOException {
        this.displayWait();
        this.playHarlem();
        this.displayIntro();
        this.afterDetach();
    }

    public void complete(CompleteOperation completeOperation) {
        if ("harlem".startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate("harlem");
        }
    }

    private void playHarlem() {
        try {
            if (!this.harlemWav.isFile() && this.allowDownload) {
                this.saveHarlem(this.harlemWav);
            }
            Clip clip = AudioSystem.getClip();
            if (this.harlemWav.isFile()) {
                clip.open(AudioSystem.getAudioInputStream(this.harlemWav));
            } else {
                clip.open(AudioSystem.getAudioInputStream(new URL("https://dl.dropbox.com/u/30971563/harlem.wav")));
            }
            clip.start();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHarlem(File harlemWav) throws IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(new URL("https://dl.dropbox.com/u/30971563/harlem.wav").openStream());
            fout = new FileOutputStream(harlemWav);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

