/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.less.aesh;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.man.AeshFileDisplayer;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.extensions.page.SimpleFileParser;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.PathResolver;

@CommandDefinition(name="less", description="less is more")
public class Less
extends AeshFileDisplayer {
    @Arguments
    List<File> arguments;
    private SimpleFileParser loader;

    public void setFile(File file) throws IOException {
        this.loader.setFile(file);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(filename);
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    public FileParser getFileParser() {
        return this.loader;
    }

    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.getInvertedBackground() + "Pattern not found (press RETURN)" + ANSI.defaultText());
        } else if (this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(":");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH) {
            if (this.isAtBottom()) {
                this.writeToConsole(ANSI.getInvertedBackground() + "(END)" + ANSI.defaultText());
            } else {
                this.writeToConsole(":");
            }
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        this.setCommandInvocation(commandInvocation);
        this.loader = new SimpleFileParser();
        if (commandInvocation.getShell().in().getStdIn().available() > 0) {
            Scanner s = new Scanner(commandInvocation.getShell().in().getStdIn()).useDelimiter("\\A");
            String fileContent = s.hasNext() ? s.next() : "";
            this.setInput(fileContent);
            this.afterAttach();
        } else if (this.arguments != null && this.arguments.size() > 0) {
            File f = this.arguments.get(0);
            if ((f = (File)PathResolver.resolvePath((File)f, (File)commandInvocation.getAeshContext().getCurrentWorkingDirectory()).get(0)).isFile()) {
                this.setFile(f);
                this.afterAttach();
            } else if (f.isDirectory()) {
                this.getShell().err().println(f.getAbsolutePath() + ": is a directory");
            } else {
                this.getShell().err().println(f.getAbsolutePath() + ": No such file or directory");
            }
        }
        return CommandResult.SUCCESS;
    }
}

