/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.more.aesh;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.extensions.page.SimpleFileParser;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.PathResolver;

@CommandDefinition(name="more", description="is more less?")
public class More
implements Command {
    private int rows;
    private int topVisibleRow;
    private int prevTopVisibleRow;
    private StringBuilder number = new StringBuilder();
    private MorePage page;
    private SimpleFileParser loader;
    private CommandInvocation commandInvocation;
    private ControlOperator operator;
    @Arguments
    private List<File> arguments;

    public void setFile(File page) throws IOException {
        this.loader.setFile(page);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(new File(filename));
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    protected void afterAttach() throws IOException {
        this.rows = this.commandInvocation.getShell().getSize().getHeight();
        int columns = this.commandInvocation.getShell().getSize().getWidth();
        this.page = new MorePage(this.loader, columns);
        if (this.operator.isRedirectionOut() || this.operator.isPipe()) {
            int count = 0;
            for (String line : this.page.getLines()) {
                this.commandInvocation.getShell().out().print(line);
                if (++count >= this.page.size()) continue;
                this.commandInvocation.getShell().out().print(Config.getLineSeparator());
            }
            this.page.clear();
            this.loader = new SimpleFileParser();
        } else {
            if (this.page.hasData()) {
                this.display(Background.INVERSE);
            }
            this.processOperation();
        }
    }

    protected void afterDetach() throws IOException {
        this.clearNumber();
        this.prevTopVisibleRow = 0;
        this.topVisibleRow = 0;
        if (!this.operator.isRedirectionOut()) {
            this.commandInvocation.getShell().out().print(Buffer.printAnsi((String)"K"));
            this.commandInvocation.getShell().out().print(Buffer.printAnsi((String)"1G"));
            this.commandInvocation.getShell().out().flush();
        }
        this.page.clear();
        this.loader = new SimpleFileParser();
    }

    public void processOperation() throws IOException {
        boolean attach = true;
        try {
            while (attach) {
                CommandOperation operation = this.commandInvocation.getInput();
                if (operation.getInputKey() == Key.q) {
                    attach = false;
                    continue;
                }
                if (operation.getInputKey() == Key.ENTER) {
                    this.topVisibleRow += this.getNumber();
                    if (this.topVisibleRow > this.page.size() - this.rows) {
                        this.topVisibleRow = this.page.size() - this.rows;
                        if (this.topVisibleRow < 0) {
                            this.topVisibleRow = 0;
                        }
                        this.display(Background.INVERSE);
                        attach = false;
                    } else {
                        this.display(Background.INVERSE);
                    }
                    this.clearNumber();
                    continue;
                }
                if (operation.getInputKey() == Key.CTRL_F || operation.getInputKey() == Key.SPACE) {
                    this.topVisibleRow += this.rows * this.getNumber();
                    if (this.topVisibleRow > this.page.size() - this.rows) {
                        this.topVisibleRow = this.page.size() - this.rows;
                        if (this.topVisibleRow < 0) {
                            this.topVisibleRow = 0;
                        }
                        this.display(Background.INVERSE);
                        attach = false;
                    } else {
                        this.display(Background.INVERSE);
                    }
                    this.clearNumber();
                    continue;
                }
                if (operation.getInputKey() == Key.CTRL_B) {
                    this.topVisibleRow -= this.rows * this.getNumber();
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display(Background.INVERSE);
                    this.clearNumber();
                    continue;
                }
                if (!Character.isDigit(operation.getInput()[0])) continue;
                this.number.append(Character.getNumericValue(operation.getInput()[0]));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.afterDetach();
    }

    private void display(Background background) throws IOException {
        this.commandInvocation.getShell().out().print(Buffer.printAnsi((String)"0G"));
        this.commandInvocation.getShell().out().print(Buffer.printAnsi((String)"2K"));
        if (this.prevTopVisibleRow == 0 && this.topVisibleRow == 0) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.commandInvocation.getShell().out().print(this.page.getLine(i));
                this.commandInvocation.getShell().out().print(Config.getLineSeparator());
            }
        } else if (this.prevTopVisibleRow < this.topVisibleRow) {
            for (int i = this.prevTopVisibleRow; i < this.topVisibleRow; ++i) {
                this.commandInvocation.getShell().out().print(this.page.getLine(i + this.rows));
                this.commandInvocation.getShell().out().print(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        } else if (this.prevTopVisibleRow > this.topVisibleRow) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.commandInvocation.getShell().out().print(this.page.getLine(i));
                this.commandInvocation.getShell().out().print(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        }
        this.displayBottom(background);
    }

    private void displayBottom(Background background) throws IOException {
        if (background == Background.INVERSE) {
            this.commandInvocation.getShell().out().print(ANSI.getInvertedBackground());
            this.commandInvocation.getShell().out().print("--More--(");
            this.commandInvocation.getShell().out().print(this.getPercentDisplayed() + "%)");
            this.commandInvocation.getShell().out().print(ANSI.getNormalBackground());
            this.commandInvocation.getShell().out().flush();
        }
    }

    private String getPercentDisplayed() {
        double row = this.topVisibleRow + this.rows;
        if (row > (double)this.page.size()) {
            row = this.page.size();
        }
        return String.valueOf((int)(row / (double)this.page.size() * 100.0));
    }

    public void displayHelp() throws IOException {
        this.commandInvocation.getShell().out().println(Config.getLineSeparator() + "Usage: more [options] file...");
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        this.commandInvocation = commandInvocation;
        this.operator = commandInvocation.getControlOperator();
        this.loader = new SimpleFileParser();
        if (commandInvocation.getShell().in().getStdIn().available() > 0) {
            Scanner s = new Scanner(commandInvocation.getShell().in().getStdIn()).useDelimiter("\\A");
            String fileContent = s.hasNext() ? s.next() : "";
            this.setInput(fileContent);
            this.afterAttach();
        } else if (this.arguments != null && this.arguments.size() > 0) {
            File f = this.arguments.get(0);
            if ((f = (File)PathResolver.resolvePath((File)f, (File)commandInvocation.getAeshContext().getCurrentWorkingDirectory()).get(0)).isFile()) {
                this.setFile(f);
                this.afterAttach();
            } else if (f.isDirectory()) {
                commandInvocation.getShell().err().println(f.getAbsolutePath() + ": is a directory");
            } else {
                commandInvocation.getShell().err().println(f.getAbsolutePath() + ": No such file or directory");
            }
        }
        return CommandResult.SUCCESS;
    }

    private class MorePage
    extends TerminalPage {
        public MorePage(FileParser fileParser, int columns) throws IOException {
            super(fileParser, columns);
        }
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

