/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.rm;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.extensions.cat.Cat;
import org.jboss.aesh.extensions.cd.Cd;
import org.jboss.aesh.extensions.common.AeshTestCommons;
import org.jboss.aesh.extensions.ls.Ls;
import org.jboss.aesh.extensions.mkdir.Mkdir;
import org.jboss.aesh.extensions.rm.Rm;
import org.jboss.aesh.extensions.touch.Touch;
import org.jboss.aesh.terminal.Key;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RmTest
extends AeshTestCommons {
    private Path tempDir;
    private FileAttribute fileAttribute = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"));

    @Before
    public void before() throws IOException {
        this.tempDir = this.createTempDirectory();
    }

    public Path createTempDirectory() throws IOException {
        Path tmp = Config.isOSPOSIXCompatible() ? Files.createTempDirectory("temp", this.fileAttribute) : Files.createTempDirectory("temp", new FileAttribute[0]);
        return tmp;
    }

    @Test
    public void testRm() throws IOException, InterruptedException, CommandLineParserException {
        this.prepare(new Class[]{Touch.class, Mkdir.class, Cd.class, Cat.class, Ls.class, Rm.class});
        String tempPath = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator();
        this.pushToOutput("touch " + tempPath + "file01.txt");
        this.pushToOutput("rm " + tempPath + "file01.txt");
        this.pushToOutput("cat " + tempPath + "file01.txt");
        Assert.assertTrue((boolean)this.getStream().toString().contains("No such file or directory"));
        this.pushToOutput("cd " + tempPath);
        this.pushToOutput("mkdir " + tempPath + "aesh_rocks");
        this.pushToOutput("rm -d " + tempPath + "aesh_rocks");
        this.pushToOutput("ls " + tempPath + "aesh_rocks");
        Assert.assertTrue((boolean)this.getStream().toString().contains("No such file or directory"));
        this.pushToOutput("touch " + tempPath + "file03.txt");
        this.pushToOutput("rm -i " + tempPath + "file03.txt");
        this.pushToOutput("y");
        this.pushToOutput("cat " + tempPath + "file03.txt");
        Assert.assertTrue((boolean)this.getStream().toString().contains("No such file or directory"));
        this.pushToOutput("cd " + tempPath);
        this.pushToOutput("mkdir " + tempPath + "aesh_rocks2");
        this.pushToOutput("rm -di " + tempPath + "aesh_rocks2");
        this.pushToOutput("y");
        this.pushToOutput("ls " + tempPath + "aesh_rocks2");
        Assert.assertTrue((boolean)this.getStream().toString().contains("No such file or directory"));
        this.getStream().reset();
        this.pushToOutput("touch " + tempPath + "file04.txt");
        this.output("rm " + tempPath + "file04.txt");
        this.output(String.valueOf(Key.CTRL_C));
        this.pushToOutput("cat " + tempPath + "file04.txt");
        Assert.assertFalse((boolean)this.getStream().toString().contains("No such file or directory"));
        this.finish();
    }
}

