/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.mkdir;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.extensions.common.AeshTestCommons;
import org.jboss.aesh.extensions.ls.Ls;
import org.jboss.aesh.extensions.mkdir.Mkdir;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MkdirTest
extends AeshTestCommons {
    private Path tempDir;
    private String aeshRocksDir;
    private String aeshRocksSubDir;
    private FileAttribute fileAttribute = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"));

    @Before
    public void before() throws IOException {
        this.tempDir = this.createTempDirectory();
        this.aeshRocksDir = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator() + "aesh_rocks";
        this.aeshRocksSubDir = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator() + "aesh_rocks" + Config.getPathSeparator() + "subdir1" + Config.getPathSeparator() + "subdir2";
    }

    public Path createTempDirectory() throws IOException {
        Path tmp = Config.isOSPOSIXCompatible() ? Files.createTempDirectory("temp", this.fileAttribute) : Files.createTempDirectory("temp", new FileAttribute[0]);
        return tmp;
    }

    @Test
    public void testMkdir() throws IOException, InterruptedException, CommandLineParserException {
        this.prepare(new Class[]{Mkdir.class, Ls.class});
        this.pushToOutput("mkdir -v " + this.aeshRocksDir);
        this.pushToOutput("ls " + this.aeshRocksDir);
        Assert.assertFalse((boolean)this.getStream().toString().contains("No such file or directory"));
        this.pushToOutput("mkdir -p " + this.aeshRocksSubDir);
        this.pushToOutput("ls " + this.aeshRocksSubDir);
        Assert.assertFalse((boolean)this.getStream().toString().contains("No such file or directory"));
        this.finish();
    }

    @After
    public void after() {
        try {
            Files.delete(new File(this.aeshRocksSubDir).toPath());
            Files.delete(new File(this.aeshRocksDir + Config.getPathSeparator() + "subdir1").toPath());
            Files.delete(new File(this.aeshRocksDir).toPath());
            Files.delete(this.tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

