/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.encoder.AssertEncoder;
import org.jboss.aesh.extensions.text.highlight.scanner.AbstractScannerTestCase;
import org.jboss.aesh.extensions.text.highlight.scanner.HTMLScanner;
import org.junit.Ignore;
import org.junit.Test;

public class HTMLScannerTestCase
extends AbstractScannerTestCase {
    @Test
    @Ignore
    public void should() throws Exception {
        String source = "<p style=\"float:right;\">#{q.answers.size.to_i} answers</p>";
        Syntax.Builder.create().scannerType(HTMLScanner.TYPE.getName()).encoderType("TEST").execute(source);
        AssertEncoder.assertTextToken(TokenType.tag, "<p");
        AssertEncoder.assertTextToken(TokenType.attribute_name, "style");
        AssertEncoder.assertTextToken(TokenType.key, "float");
    }

    @Test
    public void shouldMatchHTMLBooleanExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "boolean.in.html");
    }

    @Test
    public void shouldMatchHTMLAmpersandExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "ampersand.in.html");
    }

    @Test
    public void shouldMatchHTMLCDataExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "cdata.in.html");
    }

    @Test
    public void shouldMatchHTMLCoderayOutputExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "coderay-output.in.html");
    }

    @Test
    public void shouldMatchHTMLRedmineExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "redmine.in.html");
    }

    @Test
    public void shouldMatchHTMLTagsExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "tags.in.html");
    }

    @Test
    public void shouldMatchHTMLTolkienTagsExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "tolkien.in.html");
    }

    @Test
    public void shouldMatchHTMLTPuthTagsExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "html", "tputh.in.html");
    }
}

