/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.encoder.AssertEncoder;
import org.jboss.aesh.extensions.text.highlight.scanner.AbstractScannerTestCase;
import org.jboss.aesh.extensions.text.highlight.scanner.JavaScanner;
import org.junit.Ignore;
import org.junit.Test;

public class JavaScannerTestCase
extends AbstractScannerTestCase {
    @Test
    @Ignore
    public void should() throws Exception {
        String source = "/***** BEGIN LICENSE BLOCK ***** */\npackage pl.silvermedia.ws;\nimport java.util.List;\n\nimport javax.jws.WebParam;\nimport javax.jws.WebService;\n\n@WebService\npublic interface ContactUsService {\n  List<Message> getMessages();\n  Message[] getFirstMessage();\n    void postMessage(@WebParam(name = \"message\") Message message) throws UnsupportedOperationException {\n        if (File.separatorChar == '\\\\') {            bannerText = \"  \" + bannerText + \"  \\n\\n\";\n        }\n    }}\n";
        Syntax.Builder.create().scannerType(JavaScanner.TYPE.getName()).encoderType("TEST").execute(source);
        AssertEncoder.assertTextToken(TokenType.comment, "/***** BEGIN LICENSE BLOCK ***** */");
        AssertEncoder.assertTextToken(TokenType.namespace, "pl.silvermedia.ws");
        AssertEncoder.assertTextToken(TokenType.predefined_type, "List");
        AssertEncoder.assertTextToken(TokenType.exception, "UnsupportedOperationException");
        AssertEncoder.assertTextToken(TokenType.keyword, "import");
        AssertEncoder.assertTextToken(TokenType.type, "void", "interface", "[]");
        AssertEncoder.assertTextToken(TokenType.directive, "public");
        AssertEncoder.assertTextToken(TokenType.content, "message");
        AssertEncoder.assertTextToken(TokenType.char_, "\\n", "\\\\");
    }

    @Test
    public void shouldMatchJavaExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "java", "example.in.java");
    }

    @Test
    public void shouldMatchJavaJRubyExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "java", "jruby.in.java");
    }
}

