/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.encoder;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.aesh.extensions.text.highlight.Theme;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.encoder.DebugEncoder;
import org.junit.Assert;

public class AssertEncoder
extends DebugEncoder {
    private static List<TokenPair> textTokens = new ArrayList<TokenPair>();

    public AssertEncoder(OutputStream out, Theme theme, Map<String, Object> options) {
        super(out, theme, options);
        textTokens.clear();
    }

    public void textToken(String text, TokenType type) {
        textTokens.add(new TokenPair(text, type));
        super.textToken(text, type);
    }

    public static void assertTextToken(TokenType type, String ... texts) {
        for (String text : texts) {
            boolean found = false;
            ArrayList<TokenPair> textMatches = new ArrayList<TokenPair>();
            for (TokenPair pair : textTokens) {
                if (!pair.text.equals(text)) continue;
                textMatches.add(pair);
                if (pair.type != type) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Expected [" + text + "] of type [" + type + "]: Found matches: " + textMatches));
        }
    }

    private static class TokenPair {
        private String text;
        private TokenType type;

        public TokenPair(String text, TokenType type) {
            this.text = text;
            this.type = type;
        }

        public String toString() {
            return "[text=" + this.text + ", type=" + this.type + "]";
        }
    }
}

