/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.more.console;

import java.io.File;
import java.io.IOException;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.extensions.page.SimpleFileParser;
import org.jboss.aesh.io.FileResource;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.FileLister;

public class More
implements Completion {
    private int rows;
    private int topVisibleRow;
    private int prevTopVisibleRow;
    private StringBuilder number;
    private MorePage page;
    private SimpleFileParser loader;
    private Console console;
    private ControlOperator controlOperator;

    public More(Console console) {
        this.console = console;
    }

    public void setFile(File page) throws IOException {
        this.loader.setFile(page);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(new File(filename));
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    public void setControlOperator(ControlOperator controlOperator) {
        this.controlOperator = controlOperator;
    }

    public void afterAttach() throws IOException {
        this.loader = new SimpleFileParser();
        this.number = new StringBuilder();
        this.rows = this.console.getTerminalSize().getHeight();
        int columns = this.console.getTerminalSize().getWidth();
        this.page = new MorePage(this.loader, columns);
        if (this.controlOperator.isRedirectionOut()) {
            int count = 0;
            for (String line : this.page.getLines()) {
                this.console.getShell().out().print(line);
                if (++count >= this.page.size()) continue;
                this.console.getShell().out().print(Config.getLineSeparator());
            }
            this.afterDetach();
        } else if (this.page.hasData()) {
            this.display(Background.INVERSE);
        }
    }

    protected void afterDetach() throws IOException {
        this.clearNumber();
        this.prevTopVisibleRow = 0;
        this.topVisibleRow = 0;
        if (!this.controlOperator.isRedirectionOut()) {
            this.console.getShell().out().print(Buffer.printAnsi((String)"K"));
            this.console.getShell().out().print(Buffer.printAnsi((String)"1G"));
            this.console.getShell().out().flush();
        }
        this.page.clear();
    }

    public void processOperation(CommandOperation operation) throws IOException {
        if (operation.getInput()[0] == 113) {
            this.afterDetach();
        } else if (operation.equals(Operation.NEW_LINE)) {
            this.topVisibleRow += this.getNumber();
            if (this.topVisibleRow > this.page.size() - this.rows) {
                this.topVisibleRow = this.page.size() - this.rows;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display(Background.INVERSE);
                this.afterDetach();
            } else {
                this.display(Background.INVERSE);
            }
            this.clearNumber();
        } else if (operation.getInput()[0] == 6 || operation.getInput()[0] == 32) {
            this.topVisibleRow += this.rows * this.getNumber();
            if (this.topVisibleRow > this.page.size() - this.rows) {
                this.topVisibleRow = this.page.size() - this.rows;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display(Background.INVERSE);
                this.afterDetach();
            } else {
                this.display(Background.INVERSE);
            }
            this.clearNumber();
        } else if (operation.getInput()[0] == 2) {
            this.topVisibleRow -= this.rows * this.getNumber();
            if (this.topVisibleRow < 0) {
                this.topVisibleRow = 0;
            }
            this.display(Background.INVERSE);
            this.clearNumber();
        } else if (Character.isDigit(operation.getInput()[0])) {
            this.number.append(Character.getNumericValue(operation.getInput()[0]));
        }
    }

    private void display(Background background) throws IOException {
        this.console.getShell().out().print(Buffer.printAnsi((String)"0G"));
        this.console.getShell().out().print(Buffer.printAnsi((String)"2K"));
        if (this.prevTopVisibleRow == 0 && this.topVisibleRow == 0) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.console.getShell().out().print(this.page.getLine(i));
                this.console.getShell().out().print(Config.getLineSeparator());
            }
        } else if (this.prevTopVisibleRow < this.topVisibleRow) {
            for (int i = this.prevTopVisibleRow; i < this.topVisibleRow; ++i) {
                this.console.getShell().out().print(this.page.getLine(i + this.rows));
                this.console.getShell().out().print(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        } else if (this.prevTopVisibleRow > this.topVisibleRow) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.console.getShell().out().print(this.page.getLine(i));
                this.console.getShell().out().print(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        }
        this.displayBottom(background);
    }

    private void displayBottom(Background background) throws IOException {
        if (background == Background.INVERSE) {
            this.console.getShell().out().print(ANSI.INVERT_BACKGROUND);
            this.console.getShell().out().print("--More--(");
            this.console.getShell().out().print(this.getPercentDisplayed() + "%)");
            this.console.getShell().out().print(ANSI.NORMAL_BACKGROUND);
            this.console.getShell().out().flush();
        }
    }

    private String getPercentDisplayed() {
        double row = this.topVisibleRow + this.rows;
        if (row > (double)this.page.size()) {
            row = this.page.size();
        }
        return String.valueOf((int)(row / (double)this.page.size() * 100.0));
    }

    public void complete(CompleteOperation completeOperation) {
        if (completeOperation.getBuffer().equals("")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("m")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("mo")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("mor")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("more")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().startsWith("more ")) {
            String word = Parser.findWordClosestToCursor((String)completeOperation.getBuffer(), (int)completeOperation.getCursor());
            completeOperation.setOffset(completeOperation.getCursor());
            new FileLister(word, (Resource)new FileResource(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
        }
    }

    public void displayHelp() throws IOException {
        this.console.getShell().out().println(Config.getLineSeparator() + "Usage: more [options] file...");
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private class MorePage
    extends TerminalPage {
        public MorePage(FileParser fileParser, int columns) throws IOException {
            super(fileParser, columns);
        }
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

