/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aesh.extensions.text.highlight.TokenType;

public class Theme {
    private Color defaultColor;
    private Map<TokenType, Color> map;

    public Theme() {
        this(null);
    }

    public Theme(Color defaultColor) {
        this.defaultColor = defaultColor;
        this.map = new HashMap<TokenType, Color>();
    }

    public Theme set(Color color, TokenType type, TokenType ... types) {
        this.map.put(type, color);
        if (types != null) {
            for (TokenType t : types) {
                this.map.put(t, color);
            }
        }
        return this;
    }

    public Color lookup(TokenType type) {
        Color color = this.map.get((Object)type);
        return color != null ? color : this.defaultColor;
    }
}

