/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.aesh.extensions.text.highlight.Encoder;
import org.jboss.aesh.extensions.text.highlight.Scanner;
import org.jboss.aesh.extensions.text.highlight.StringScanner;
import org.jboss.aesh.extensions.text.highlight.TokenType;

public class YAMLScanner
implements Scanner {
    private static final Pattern SPACE = Pattern.compile(" +[\\t ]*");
    private static final Pattern SPACE_NEWLINE = Pattern.compile("\\n+");
    private static final Pattern COMMENT = Pattern.compile("#.*");
    private static final Pattern HEAD = Pattern.compile("---|\\.\\.\\.");
    private static final Pattern DOCTYPE = Pattern.compile("%.*");
    private static final Pattern STRING = Pattern.compile("(?:\"[^\"]*\")(?=: |:$)", 8);
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\"");
    private static final Pattern COMMENT_ONELINE = Pattern.compile(" [^\"\\\\]* (?: \\\\. [^\"\\\\]* )* ", 36);
    private static final Pattern LINE_CONTINUE = Pattern.compile("[|>][-+]?");
    private static final Pattern STRING_ENDLINE = Pattern.compile("(?![!\"*&]).+?(?=$|\\s+#)", 8);
    private static final Pattern OPERATOR = Pattern.compile("[-:](?= |$)", 8);
    private static final Pattern OPERATOR_BRACKETS = Pattern.compile("[,{}\\[\\]]");
    private static final Pattern KEY = Pattern.compile("[-\\w.()\\/ ]*\\S(?= *:(?: |$))", 8);
    private static final Pattern KEY_2 = Pattern.compile("(?:\"[^\"\\n]*\"|'[^'\\n]*')(?= *:(?: |$))", 8);
    private static final Pattern TYPE_EXP = Pattern.compile("(![\\w\\/]+)(:([\\w:]+))?");
    private static final Pattern VARIABLE = Pattern.compile("&\\S+");
    private static final Pattern GLOBAL_VARIABLE = Pattern.compile("\\*\\w+");
    private static final Pattern CLASS_VARIABLE = Pattern.compile("<<");
    private static final Pattern OCTAL = Pattern.compile("\\d\\d:\\d\\d:\\d\\d");
    private static final Pattern OCTAL_2 = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d(\\.\\d+)? [-+]\\d\\d:\\d\\d");
    private static final Pattern SYMBOL = Pattern.compile(":\\w+");
    private static final Pattern ERROR = Pattern.compile("[^:\\s]+(:(?! |$)[^:\\s]*)* .*");
    private static final Pattern ERROR_2 = Pattern.compile("[^:\\s]+(:(?! |$)[^:\\s]*)*");
    public static final Scanner.Type TYPE = new Scanner.Type("YAML", "\\.(yml|yaml)$");

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        Context contxt = new Context();
        contxt.state = State.initial;
        contxt.key_indent = null;
        while (source.hasMore()) {
            MatchResult m = null;
            if (source.isBeginningOfLine()) {
                contxt.key_indent = null;
            }
            if ((m = source.scan(SPACE)) != null) {
                encoder.textToken(m.group(), TokenType.space);
                continue;
            }
            m = source.scan(SPACE_NEWLINE);
            if (m != null) {
                encoder.textToken(m.group(), TokenType.space);
                if (m.group().indexOf("\n") == -1) continue;
                contxt.state = State.initial;
                continue;
            }
            m = source.scan(COMMENT);
            if (m != null) {
                encoder.textToken(m.group(), TokenType.comment);
                continue;
            }
            if (source.isBeginningOfLine() && this.head_doctype(source, encoder) || contxt.state == State.value && this.delimiter(source, encoder, contxt) || this.value(source, encoder, contxt)) continue;
            if (!source.hasMore()) {
                throw new RuntimeException("unexpected end");
            }
            encoder.textToken(source.next(), TokenType.error);
        }
    }

    private boolean head_doctype(StringScanner source, Encoder encoder) {
        MatchResult m = source.scan(HEAD);
        if (m != null) {
            encoder.beginGroup(TokenType.head);
            encoder.textToken(m.group(), TokenType.head);
            encoder.endGroup(TokenType.head);
            return true;
        }
        m = source.scan(DOCTYPE);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.doctype);
            return true;
        }
        return false;
    }

    private boolean delimiter(StringScanner source, Encoder encoder, Context context) {
        MatchResult m;
        int string_indent = 0;
        if (source.check(STRING) == null && (m = source.scan(DOUBLE_QUOTE)) != null) {
            encoder.beginGroup(TokenType.string);
            encoder.textToken(m.group(), TokenType.delimiter);
            m = source.scan(COMMENT_ONELINE);
            if (m != null && !"".equals(m.group())) {
                encoder.textToken(m.group(), TokenType.content);
            }
            if ((m = source.scan(DOUBLE_QUOTE)) != null) {
                encoder.textToken(m.group(), TokenType.delimiter);
            }
            encoder.endGroup(TokenType.string);
            return true;
        }
        m = source.scan(LINE_CONTINUE);
        if (m != null) {
            encoder.beginGroup(TokenType.string);
            encoder.textToken(m.group(), TokenType.delimiter);
            string_indent = context.key_indent != null ? context.key_indent : source.column(source.index() - m.group().length()) - 1;
            m = source.scan(Pattern.compile("(?:\\n+ {" + (string_indent + 1) + "}.*)+"));
            if (m != null) {
                encoder.textToken(m.group(), TokenType.content);
            }
            encoder.endGroup(TokenType.string);
            return true;
        }
        m = source.scan(STRING_ENDLINE);
        if (m != null) {
            encoder.beginGroup(TokenType.string);
            encoder.textToken(m.group(), TokenType.content);
            string_indent = context.key_indent != null ? context.key_indent : source.column(source.index() - m.group().length()) - 1;
            m = source.scan(Pattern.compile("(?:\\n+ {" + (string_indent + 1) + "}.*)+"));
            if (m != null) {
                encoder.textToken(m.group(), TokenType.content);
            }
            encoder.endGroup(TokenType.string);
            return true;
        }
        return false;
    }

    private boolean value(StringScanner source, Encoder encoder, Context context) {
        MatchResult m = source.scan(OPERATOR);
        if (m != null) {
            if (context.state == State.colon && m.group().equals(":") | m.group().equals("-")) {
                context.state = State.value;
            } else if (context.state == State.initial && m.group().equals("-")) {
                context.state = State.value;
            }
            encoder.textToken(m.group(), TokenType.operator);
            return true;
        }
        m = source.scan(OPERATOR_BRACKETS);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.operator);
            return true;
        }
        if (context.state == State.initial && (m = source.scan(KEY)) != null) {
            encoder.textToken(m.group(), TokenType.key);
            context.key_indent = source.column(source.index() - m.group().length()) - 1;
            context.state = State.colon;
            return true;
        }
        m = source.scan(KEY_2);
        if (m != null) {
            encoder.beginGroup(TokenType.key);
            String match = m.group();
            encoder.textToken(match.substring(0, 1), TokenType.delimiter);
            if (match.length() > 2) {
                encoder.textToken(match.substring(1, match.length() - 1), TokenType.content);
            }
            encoder.textToken(match.substring(match.length() - 1), TokenType.delimiter);
            encoder.endGroup(TokenType.key);
            context.key_indent = source.column(source.index() - match.length()) - 1;
            context.state = State.colon;
            return true;
        }
        m = source.scan(TYPE_EXP);
        if (m != null) {
            encoder.textToken(m.group(1), TokenType.type);
            if (m.group(2) != null) {
                encoder.textToken(":", TokenType.operator);
                encoder.textToken(m.group(3), TokenType.class_);
            }
            return true;
        }
        m = source.scan(VARIABLE);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.variable);
            return true;
        }
        m = source.scan(GLOBAL_VARIABLE);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.global_variable);
            return true;
        }
        m = source.scan(CLASS_VARIABLE);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.class_variable);
            return true;
        }
        m = source.scan(OCTAL);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.octal);
            return true;
        }
        m = source.scan(OCTAL_2);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.octal);
            return true;
        }
        m = source.scan(SYMBOL);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.symbol);
            return true;
        }
        m = source.scan(ERROR);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.error);
            return true;
        }
        m = source.scan(ERROR_2);
        if (m != null) {
            encoder.textToken(m.group(), TokenType.error);
            return true;
        }
        return false;
    }

    private static class Context {
        State state;
        Integer key_indent = null;

        private Context() {
        }
    }

    public static enum State {
        initial,
        value,
        colon;

    }
}

