/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.encoder.AssertEncoder;
import org.jboss.aesh.extensions.text.highlight.scanner.AbstractScannerTestCase;
import org.jboss.aesh.extensions.text.highlight.scanner.PropertiesScanner;
import org.junit.Test;

public class PropertiesScannerTestCase
extends AbstractScannerTestCase {
    @Test
    public void should() throws Exception {
        String source = "# You are reading the \".properties\" entry.\n! The exclamation mark can also mark text as comments.\n# The key and element characters #, !, =, and : are written with\n# a preceding backslash to ensure that they are properly loaded.\nwebsite = http\\://en.wikipedia.org/\nlanguage = English\nlanguage2=Franch\n# The backslash below tells the application to continue reading\n# the value onto the next line.\nmessage = Welcome to \\\n          Wikipedia\\!\n# Add spaces to the key\nkey\\ with\\ spaces = This is the value that could be looked up with the key \"key with spaces\".\n# Unicode\ntab : \\u0009\nnumber : 100\nfloat : 100.0\n";
        Syntax.Builder.create().scannerType(PropertiesScanner.TYPE.getName()).encoderType("TEST").execute(source);
        AssertEncoder.assertTextToken(TokenType.comment, "# You are reading the \".properties\" entry.", "! The exclamation mark can also mark text as comments.");
        AssertEncoder.assertTextToken(TokenType.value, "English", "Welcome to \\", "Wikipedia\\!");
        AssertEncoder.assertTextToken(TokenType.key, "website", "language", "language2", "key\\ with\\ spaces", "tab");
        AssertEncoder.assertTextToken(TokenType.float_, "100.0");
        AssertEncoder.assertTextToken(TokenType.integer, "100");
    }
}

