/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.readline.Buffer;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.util.ANSI;
import org.junit.Assert;
import org.junit.Test;

public class BufferTest {
    @Test
    public void insertNoPrompt() {
        Buffer buffer = new Buffer();
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, 65, 10);
        Assert.assertEquals((long)1L, (long)buffer.length());
        Assert.assertEquals((long)65L, (long)buffer.get(0));
        buffer.insert(outConsumer::add, 66, 10);
        buffer.insert(outConsumer::add, 67, 10);
        Assert.assertEquals((long)66L, (long)buffer.get(1));
        Assert.assertEquals((long)67L, (long)buffer.get(2));
        Assert.assertArrayEquals((int[])new int[]{65}, (int[])((int[])outConsumer.get(0)));
        Assert.assertArrayEquals((int[])new int[]{66}, (int[])((int[])outConsumer.get(1)));
        Assert.assertArrayEquals((int[])new int[]{67}, (int[])((int[])outConsumer.get(2)));
        buffer.reset();
        outConsumer.clear();
        buffer.print(outConsumer::add, 120);
        Assert.assertTrue((((int[])outConsumer.get(0)).length == 0 ? 1 : 0) != 0);
        buffer.insert(outConsumer::add, 65, 10);
        buffer.insert(outConsumer::add, 66, 10);
        buffer.insert(outConsumer::add, 67, 10);
        Assert.assertEquals((long)66L, (long)buffer.get(1));
        Assert.assertEquals((long)67L, (long)buffer.get(2));
        outConsumer.clear();
        buffer.insert(outConsumer::add, " foo", 10);
        Assert.assertEquals((Object)" foo", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
    }

    @Test
    public void insert() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.print(outConsumer::add, 100);
        buffer.insert(outConsumer::add, 65, 100);
        Assert.assertEquals((long)1L, (long)buffer.length());
        Assert.assertEquals((long)65L, (long)buffer.get(0));
        buffer.insert(outConsumer::add, 66, 100);
        buffer.insert(outConsumer::add, 67, 100);
        Assert.assertEquals((long)66L, (long)buffer.get(1));
        Assert.assertEquals((long)67L, (long)buffer.get(2));
        Assert.assertEquals((Object)": ", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
        Assert.assertArrayEquals((int[])new int[]{65}, (int[])((int[])outConsumer.get(1)));
        Assert.assertArrayEquals((int[])new int[]{66}, (int[])((int[])outConsumer.get(2)));
        Assert.assertArrayEquals((int[])new int[]{67}, (int[])((int[])outConsumer.get(3)));
        Assert.assertEquals((Object)"ABC", (Object)buffer.getLineAsString());
        buffer.reset();
        outConsumer.clear();
        buffer.print(outConsumer::add, 120);
        Assert.assertEquals((Object)": ", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
        Assert.assertEquals((long)1L, (long)outConsumer.size());
        buffer.insert(outConsumer::add, 65, 100);
        buffer.insert(outConsumer::add, 66, 100);
        buffer.insert(outConsumer::add, 67, 100);
        Assert.assertEquals((long)66L, (long)buffer.get(1));
        Assert.assertEquals((long)67L, (long)buffer.get(2));
        outConsumer.clear();
        buffer.insert(outConsumer::add, " foo", 100);
        Assert.assertEquals((Object)" foo", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
    }

    @Test
    public void insertString() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        buffer.insert(outConsumer::add, " ", 100);
        buffer.insert(outConsumer::add, "foo bar", 100);
        Assert.assertEquals((Object)": ", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), 0, 2)));
        Assert.assertEquals((Object)"foo bar", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), 2, 9)));
        Assert.assertEquals((Object)" ", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(1))));
        Assert.assertEquals((Object)"foo bar", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(2))));
        buffer = new Buffer(new Prompt(": "));
        outConsumer.clear();
        buffer.insert(outConsumer::add, "foo", 100);
        buffer.move(outConsumer::add, -10, 100);
        outConsumer.clear();
        buffer.insert(outConsumer::add, "1", 100);
        Assert.assertArrayEquals((int[])new int[]{49, 102, 111, 111, 27, 91, 51, 68}, (int[])((int[])outConsumer.get(0)));
    }

    @Test
    public void delete() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        outConsumer.clear();
        buffer.delete(outConsumer::add, -2, 120);
        Assert.assertArrayEquals((int[])new int[]{27, 91, 57, 68}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 0, 4));
        Assert.assertArrayEquals((int[])new int[]{27, 91, 75}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 4, 7));
        Assert.assertEquals((Object)"foo b", (Object)buffer.getLineAsString());
        outConsumer.clear();
        buffer.delete(outConsumer::add, -2, 120);
        Assert.assertArrayEquals((int[])new int[]{27, 91, 55, 68}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 0, 4));
        Assert.assertArrayEquals((int[])new int[]{27, 91, 75}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 4, 7));
        Assert.assertEquals((Object)"foo", (Object)buffer.getLineAsString());
        outConsumer.clear();
        buffer.delete(outConsumer::add, -4, 120);
        Assert.assertArrayEquals((int[])new int[]{27, 91, 53, 68}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 0, 4));
        Assert.assertArrayEquals((int[])new int[]{27, 91, 75}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 4, 7));
        Assert.assertEquals((Object)"", (Object)buffer.getLineAsString());
    }

    @Test
    public void move() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
        buffer.move(outConsumer::add, 1, 120);
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
        buffer.move(outConsumer::add, -1, 120);
        Assert.assertEquals((long)6L, (long)buffer.getCursor());
        buffer.move(outConsumer::add, -100, 120);
        Assert.assertEquals((long)0L, (long)buffer.getCursor());
        buffer.move(outConsumer::add, 100, 120);
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
    }

    @Test
    public void moveAndInsert() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        buffer.move(outConsumer::add, -1, 120);
        buffer.insert(outConsumer::add, 65, 100);
        outConsumer.clear();
        Assert.assertEquals((Object)"foo baAr", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, -1, 120);
        outConsumer.clear();
        buffer.insert(outConsumer::add, 98, 100);
        Assert.assertEquals((Object)"foo babAr", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, -10, 120);
        outConsumer.clear();
        buffer.insert(outConsumer::add, "foo ", 100);
        Assert.assertEquals((Object)"foo foo babAr", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, 20, 120);
        outConsumer.clear();
        buffer.insert(outConsumer::add, " bar", 100);
        Assert.assertEquals((Object)" bar", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
    }

    @Test
    public void moveAndDelete() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        buffer.move(outConsumer::add, -3, 120);
        outConsumer.clear();
        buffer.delete(outConsumer::add, -1, 120);
        Assert.assertEquals((Object)"foobar", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, 1, 120);
        outConsumer.clear();
        buffer.delete(outConsumer::add, -3, 120);
        Assert.assertEquals((Object)"far", (Object)buffer.getLineAsString());
        outConsumer.clear();
        buffer.delete(outConsumer::add, 2, 120);
        Assert.assertEquals((Object)"f", (Object)buffer.getLineAsString());
        outConsumer.clear();
        buffer.delete(outConsumer::add, 2, 120);
        Assert.assertEquals((Object)"f", (Object)buffer.getLineAsString());
        outConsumer.clear();
        buffer.delete(outConsumer::add, -5, 120);
        Assert.assertEquals((Object)"", (Object)buffer.getLineAsString());
    }

    @Test
    public void replaceChar() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        outConsumer.clear();
        buffer.replace(outConsumer::add, 'R');
        Assert.assertEquals((Object)"R", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
        outConsumer.clear();
        Assert.assertEquals((Object)"foo bar", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, -1, 120);
        buffer.replace(outConsumer::add, 'R');
        Assert.assertEquals((Object)"foo baR", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, -4, 120);
        buffer.replace(outConsumer::add, 'O');
        Assert.assertEquals((Object)"foO baR", (Object)buffer.getLineAsString());
    }

    @Test
    public void changeCase() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        buffer.move(outConsumer::add, -1, 120);
        outConsumer.clear();
        buffer.upCase(outConsumer::add);
        Assert.assertEquals((Object)"R", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
        Assert.assertEquals((Object)"foo baR", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, -4, 120);
        outConsumer.clear();
        buffer.changeCase(outConsumer::add);
        Assert.assertEquals((Object)"foO baR", (Object)buffer.getLineAsString());
        outConsumer.clear();
        buffer.changeCase(outConsumer::add);
        Assert.assertEquals((Object)"foo baR", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, 10, 120);
        outConsumer.clear();
        buffer.downCase(outConsumer::add);
        Assert.assertEquals((Object)"foo baR", (Object)buffer.getLineAsString());
        buffer.move(outConsumer::add, -1, 120);
        outConsumer.clear();
        buffer.downCase(outConsumer::add);
        Assert.assertEquals((Object)"foo bar", (Object)buffer.getLineAsString());
    }

    @Test
    public void replace() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar", 100);
        outConsumer.clear();
        buffer.replace(outConsumer::add, " gar", 120);
        Assert.assertEquals((Object)" gar", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), ((int[])outConsumer.get(0)).length - 4, ((int[])outConsumer.get(0)).length)));
        outConsumer.clear();
        buffer.insert(outConsumer::add, 100, 100);
        Assert.assertEquals((Object)" gard", (Object)buffer.getLineAsString());
        Assert.assertEquals((Object)"d", (Object)Parser.fromCodePoints((int[])((int[])outConsumer.get(0))));
    }

    @Test
    public void multiLine() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo bar \\", 100);
        buffer.setMultiLine(true);
        buffer.updateMultiLineBuffer();
        outConsumer.clear();
        buffer.insert(outConsumer::add, " bar ", 100);
        Assert.assertEquals((Object)">  bar ", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), ((int[])outConsumer.get(0)).length - 7, ((int[])outConsumer.get(0)).length)));
        Assert.assertEquals((Object)"foo bar  bar ", (Object)buffer.asString());
        buffer.insert(outConsumer::add, "\\", 100);
        buffer.updateMultiLineBuffer();
        outConsumer.clear();
        buffer.insert(outConsumer::add, "gar", 100);
        Assert.assertEquals((Object)"> gar", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), ((int[])outConsumer.get(0)).length - 5, ((int[])outConsumer.get(0)).length)));
        Assert.assertEquals((Object)"foo bar  bar gar", (Object)buffer.asString());
    }

    @Test
    public void manyLinesInsert() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "1234567890", 100);
        outConsumer.clear();
        buffer.move(outConsumer::add, -10, 5);
        Assert.assertArrayEquals((int[])new int[]{27, 91, 50, 65, 27, 91, 48, 68}, (int[])((int[])outConsumer.get(0)));
        buffer.insert(outConsumer::add, 32, 100);
        outConsumer.clear();
        buffer.print(outConsumer::add, 5);
        Assert.assertEquals((Object)" 1234567890", (Object)buffer.asString());
        outConsumer.clear();
        buffer.move(outConsumer::add, 5, 5);
        Assert.assertArrayEquals((int[])new int[]{27, 91, 49, 66, 27, 91, 48, 68}, (int[])((int[])outConsumer.get(0)));
        buffer.insert(outConsumer::add, 32, 100);
        outConsumer.clear();
        buffer.print(outConsumer::add, 5);
        Assert.assertEquals((Object)" 12345 67890", (Object)buffer.asString());
        buffer.move(outConsumer::add, 13, 5);
        buffer.insert(outConsumer::add, 32, 100);
        outConsumer.clear();
        buffer.print(outConsumer::add, 5);
        Assert.assertEquals((Object)" 12345 67890 ", (Object)buffer.asString());
        buffer.move(outConsumer::add, -3, 5);
        buffer.insert(outConsumer::add, 32, 100);
        outConsumer.clear();
        buffer.print(outConsumer::add, 5);
        Assert.assertEquals((Object)" 12345 678 90 ", (Object)buffer.asString());
    }

    @Test
    public void replaceMultiLine() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "1234567890", 100);
        outConsumer.clear();
        buffer.replace(outConsumer::add, "foo", 5);
        Assert.assertArrayEquals((int[])ANSI.ERASE_WHOLE_LINE, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 0, 4));
        Assert.assertArrayEquals((int[])ANSI.MOVE_LINE_UP, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 4, 8));
        Assert.assertArrayEquals((int[])ANSI.ERASE_WHOLE_LINE, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 8, 12));
        Assert.assertArrayEquals((int[])ANSI.MOVE_LINE_UP, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 12, 16));
        Assert.assertArrayEquals((int[])new int[]{27, 91, 49, 50, 68}, (int[])Arrays.copyOfRange((int[])outConsumer.get(0), 16, 21));
        Assert.assertEquals((Object)"foo", (Object)buffer.getLineAsString());
    }

    @Test
    public void disablePrompt() {
        Buffer buffer = new Buffer(new Prompt(": "));
        ArrayList outConsumer = new ArrayList();
        buffer.insert(outConsumer::add, "foo", 100);
        Assert.assertEquals((Object)": foo", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), ((int[])outConsumer.get(0)).length - 5, ((int[])outConsumer.get(0)).length)));
        buffer.clear();
        buffer.insert(outConsumer::add, "foo", 100);
        Assert.assertEquals((Object)": foo", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), ((int[])outConsumer.get(0)).length - 5, ((int[])outConsumer.get(0)).length)));
        buffer.clear();
        buffer.disablePrompt(true);
        buffer.insert(outConsumer::add, "foo", 100);
        Assert.assertEquals((Object)"foo", (Object)Parser.fromCodePoints((int[])Arrays.copyOfRange((int[])outConsumer.get(0), ((int[])outConsumer.get(0)).length - 3, ((int[])outConsumer.get(0)).length)));
    }
}

