/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.completion;

import java.util.List;
import org.jboss.aesh.readline.completion.CompleteOperation;
import org.jboss.aesh.terminal.formatting.TerminalString;
import org.junit.Assert;
import org.junit.Test;

public class CompleteOperationTest {
    @Test
    public void testGetFormattedCompletionCandidates() {
        CompleteOperation co = new CompleteOperation("ls foob", 6);
        co.addCompletionCandidate("foobar");
        co.addCompletionCandidate("foobars");
        co.setOffset(3);
        List formattedCandidates = co.getFormattedCompletionCandidates();
        Assert.assertEquals((Object)"bar", formattedCandidates.get(0));
        Assert.assertEquals((Object)"bars", formattedCandidates.get(1));
    }

    @Test
    public void testRemoveEscapedSpacesFromCompletionCandidates() {
        CompleteOperation co = new CompleteOperation("ls foob", 6);
        co.addCompletionCandidate("foo\\ bar");
        co.addCompletionCandidate("foo\\ bars");
        co.setOffset(3);
        co.removeEscapedSpacesFromCompletionCandidates();
        Assert.assertEquals((Object)"foo bar", (Object)((TerminalString)co.getCompletionCandidates().get(0)).getCharacters());
        Assert.assertEquals((Object)"foo bars", (Object)((TerminalString)co.getCompletionCandidates().get(1)).getCharacters());
    }
}

