/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.editing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.aesh.readline.ActionDecoder;
import org.jboss.aesh.readline.Variable;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.readline.editing.InputrcParser;
import org.jboss.aesh.util.Config;
import org.junit.Assert;
import org.junit.Test;

public class InputrcParserTest {
    @Test
    public void testParseInputrc() throws IOException {
        EditMode editMode = InputrcParser.parseInputrc((InputStream)new FileInputStream(Config.isOSPOSIXCompatible() ? new File("src/test/resources/inputrc1") : new File("src\\test\\resources\\inputrc1")));
        Assert.assertEquals((Object)"vi", (Object)editMode.getVariableValue(Variable.EDITING_MODE));
        Assert.assertEquals((Object)"visible", (Object)editMode.getVariableValue(Variable.BELL_STYLE));
        Assert.assertEquals((long)300L, (long)Integer.parseInt(editMode.getVariableValue(Variable.HISTORY_SIZE)));
        Assert.assertEquals((Object)"on", (Object)editMode.getVariableValue(Variable.DISABLE_COMPLETION));
    }

    @Test
    public void testParseInputrc2() throws IOException {
        if (Config.isOSPOSIXCompatible()) {
            EditMode editMode = EditModeBuilder.builder().create();
            ActionDecoder actionQueue = new ActionDecoder();
            actionQueue.add(new int[]{27, 91, 68});
            Assert.assertEquals((Object)"backward-char", (Object)editMode.parse(actionQueue.next()).name());
            actionQueue.add(new int[]{27, 91, 66});
            Assert.assertEquals((Object)"next-history", (Object)editMode.parse(actionQueue.next()).name());
            actionQueue.add(1);
            Assert.assertEquals((Object)"beginning-of-line", (Object)editMode.parse(actionQueue.next()).name());
            editMode = InputrcParser.parseInputrc((InputStream)new FileInputStream(Config.isOSPOSIXCompatible() ? new File("src/test/resources/inputrc2") : new File("src\\test\\resources\\inputrc2")));
            actionQueue.add(new int[]{27, 91, 68});
            Assert.assertEquals((Object)"forward-char", (Object)editMode.parse(actionQueue.next()).name());
            actionQueue.add(new int[]{27, 91, 66});
            Assert.assertEquals((Object)"previous-history", (Object)editMode.parse(actionQueue.next()).name());
            actionQueue.add(new int[]{27, 10});
            Assert.assertEquals((Object)"backward-char", (Object)editMode.parse(actionQueue.next()).name());
            actionQueue.add(1);
            Assert.assertEquals((Object)"forward-word", (Object)editMode.parse(actionQueue.next()).name());
        }
    }
}

