/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.history;

import java.io.File;
import java.io.IOException;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.readline.history.FileHistory;
import org.jboss.aesh.readline.history.InMemoryHistory;
import org.jboss.aesh.readline.history.SearchDirection;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.tty.TestConnection;
import org.jboss.aesh.util.Config;
import org.jboss.aesh.util.FileAccessPermission;
import org.junit.Assert;
import org.junit.Test;

public class HistoryTest {
    @Test
    public void testHistory() throws Exception {
        TestConnection term = new TestConnection(EditModeBuilder.builder((EditMode.Mode)EditMode.Mode.EMACS).create());
        term.read("1234" + Config.getLineSeparator());
        term.readline();
        term.read("567" + Config.getLineSeparator());
        term.readline();
        term.read(Key.UP);
        term.read(Key.UP);
        term.read(Key.ENTER);
        term.assertLine("1234");
        term.readline();
        term.read(Key.UP);
        term.read(Key.UP);
        term.read(Key.ENTER);
        term.assertLine("567");
    }

    @Test
    public void testSearch() {
        InMemoryHistory history = new InMemoryHistory(20);
        history.push("foo1");
        history.push("foo2");
        history.push("foo3");
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertEquals((Object)"foo3", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo2", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo1", (Object)history.search("foo"));
        history.setSearchDirection(SearchDirection.FORWARD);
        Assert.assertEquals((Object)"foo1", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo2", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo3", (Object)history.search("foo"));
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertEquals((Object)"foo3", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo2", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo1", (Object)history.search("foo"));
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertEquals((Object)"foo3", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo2", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo1", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo3", (Object)history.search("foo"));
    }

    @Test
    public void testSearchAndFetch() {
        InMemoryHistory history = new InMemoryHistory(20);
        history.push("foo1");
        history.push("foo2");
        history.push("foo3");
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertEquals((Object)"foo3", (Object)history.search("foo"));
        Assert.assertEquals((Object)"foo2", (Object)history.getPreviousFetch());
    }

    @Test
    public void testHistorySize() {
        InMemoryHistory history = new InMemoryHistory(20);
        for (int i = 0; i < 25; ++i) {
            history.push(String.valueOf(i));
        }
        Assert.assertEquals((long)20L, (long)history.size());
        Assert.assertEquals((Object)"24", (Object)history.getPreviousFetch());
    }

    @Test
    public void testClear() {
        InMemoryHistory history = new InMemoryHistory(10);
        history.push("1");
        history.push("2");
        Assert.assertEquals((Object)"2", (Object)history.getPreviousFetch());
        history.clear();
        Assert.assertEquals(null, (Object)history.getPreviousFetch());
    }

    @Test
    public void testDupes() {
        InMemoryHistory history = new InMemoryHistory(10);
        history.push("1");
        history.push("2");
        history.push("3");
        history.push("1");
        history.push("1");
        Assert.assertEquals((Object)"1", (Object)history.getPreviousFetch());
        Assert.assertEquals((Object)"3", (Object)history.getPreviousFetch());
        Assert.assertEquals((Object)"1", (Object)history.getNextFetch());
        Assert.assertEquals((Object)"3", (Object)history.getPreviousFetch());
        Assert.assertEquals((Object)"2", (Object)history.getPreviousFetch());
        Assert.assertEquals((Object)"1", (Object)history.getPreviousFetch());
        Assert.assertEquals((long)4L, (long)history.getAll().size());
    }

    @Test
    public void testFileHistoryPermission() throws IOException {
        File historyFile = new File(System.getProperty("java.io.tmpdir"), "aesh-history-file.test.1");
        historyFile.deleteOnExit();
        int maxSize = 10;
        FileAccessPermission perm = new FileAccessPermission();
        perm.setExecutable(false);
        perm.setExecutableOwnerOnly(false);
        perm.setReadable(true);
        perm.setReadableOwnerOnly(true);
        perm.setWritable(true);
        perm.setWritableOwnerOnly(true);
        FileHistory history = new FileHistory(historyFile, maxSize, perm, false);
        history.push("1");
        history.stop();
        Assert.assertTrue((boolean)historyFile.canRead());
        Assert.assertFalse((boolean)historyFile.canExecute());
        Assert.assertTrue((boolean)historyFile.canWrite());
        historyFile = new File(System.getProperty("java.io.tmpdir"), "aesh-history-file.test.2");
        historyFile.deleteOnExit();
        perm = new FileAccessPermission();
        perm.setExecutable(true);
        perm.setExecutableOwnerOnly(true);
        perm.setReadable(false);
        perm.setReadableOwnerOnly(true);
        perm.setWritable(true);
        perm.setWritableOwnerOnly(true);
        history = new FileHistory(historyFile, maxSize, perm, false);
        history.push("1");
        history.stop();
        Assert.assertFalse((boolean)historyFile.canRead());
        Assert.assertTrue((boolean)historyFile.canExecute());
        Assert.assertTrue((boolean)historyFile.canWrite());
        historyFile = new File(System.getProperty("java.io.tmpdir"), "aesh-history-file.test.3");
        historyFile.deleteOnExit();
        perm = new FileAccessPermission();
        perm.setExecutable(false);
        perm.setExecutableOwnerOnly(true);
        perm.setReadable(false);
        perm.setReadableOwnerOnly(true);
        perm.setWritable(false);
        perm.setWritableOwnerOnly(true);
        history = new FileHistory(historyFile, maxSize, perm, false);
        history.push("1");
        history.stop();
        Assert.assertFalse((boolean)historyFile.canRead());
        Assert.assertFalse((boolean)historyFile.canExecute());
        Assert.assertFalse((boolean)historyFile.canWrite());
    }

    @Test
    public void testPrevHistory() {
        InMemoryHistory history = new InMemoryHistory(20);
        history.push("foo1");
        history.push("foo2");
        history.push("foo3");
        Assert.assertEquals((Object)"foo3", (Object)history.getPreviousFetch());
        history.push("foo3");
        Assert.assertEquals((Object)"foo3", (Object)history.getPreviousFetch());
    }
}

