/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import org.jboss.aesh.readline.Action;
import org.jboss.aesh.readline.ActionDecoder;
import org.jboss.aesh.readline.KeyAction;
import org.jboss.aesh.readline.actions.ActionMapper;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.Config;
import org.junit.Assert;
import org.junit.Test;

public class KeyTest {
    @Test
    public void testContain() {
        Assert.assertTrue((boolean)Key.ESC.containKey(new int[]{27, 10}));
    }

    @Test
    public void testOtherOperations() {
        EditMode editMode = EditModeBuilder.builder((EditMode.Mode)EditMode.Mode.EMACS).create();
        Key up = Key.UP;
        Action action = editMode.parse((KeyAction)up);
        Assert.assertEquals((Object)action.name(), (Object)ActionMapper.mapToAction((String)"previous-history").name());
        if (Config.isOSPOSIXCompatible()) {
            int[] doubleUpKey = new int[6];
            for (int i = 0; i < 6; ++i) {
                doubleUpKey[i] = i > 2 ? up.getKeyValues()[i - 3] : up.getKeyValues()[i];
            }
            ActionDecoder actionDecoder = new ActionDecoder(editMode);
            actionDecoder.add(doubleUpKey);
            action = editMode.parse(actionDecoder.next());
            Assert.assertEquals((Object)action.name(), (Object)ActionMapper.mapToAction((String)"previous-history").name());
        }
    }

    @Test
    public void testFindStartKey() {
        int[] input = new int[]{2, 27, 65};
        Key inc = Key.findStartKey((int[])input);
        Assert.assertEquals((Object)Key.CTRL_B, (Object)inc);
        System.arraycopy(input, inc.getKeyValues().length, input, 0, input.length - inc.getKeyValues().length);
        inc = Key.findStartKey((int[])input);
        Assert.assertEquals((Object)Key.ESC, (Object)inc);
        System.arraycopy(input, inc.getKeyValues().length, input, 0, input.length - inc.getKeyValues().length);
        inc = Key.findStartKey((int[])input);
        Assert.assertEquals((Object)Key.A, (Object)inc);
        if (Config.isOSPOSIXCompatible()) {
            input = new int[]{32, 27, 91, 65, 10};
            inc = Key.findStartKey((int[])input);
            Assert.assertEquals((Object)Key.SPACE, (Object)inc);
            System.arraycopy(input, inc.getKeyValues().length, input, 0, input.length - inc.getKeyValues().length);
            inc = Key.findStartKey((int[])input);
            Assert.assertEquals((Object)Key.UP, (Object)inc);
            System.arraycopy(input, inc.getKeyValues().length, input, 0, input.length - inc.getKeyValues().length);
            inc = Key.findStartKey((int[])input);
            Assert.assertEquals((Object)Key.ENTER, (Object)inc);
            System.arraycopy(input, inc.getKeyValues().length, input, 0, input.length - inc.getKeyValues().length);
        }
    }

    @Test
    public void testFindStartKeyPosition() {
        int[] input = new int[]{2, 27, 65};
        Key inc = Key.findStartKey((int[])input, (int)0);
        Assert.assertEquals((Object)Key.CTRL_B, (Object)inc);
        inc = Key.findStartKey((int[])input, (int)1);
        Assert.assertEquals((Object)Key.ESC, (Object)inc);
        System.arraycopy(input, inc.getKeyValues().length, input, 0, input.length - inc.getKeyValues().length);
        inc = Key.findStartKey((int[])input, (int)2);
        Assert.assertEquals((Object)Key.A, (Object)inc);
        if (Config.isOSPOSIXCompatible()) {
            input = new int[]{32, 27, 91, 65, 10};
            inc = Key.findStartKey((int[])input, (int)0);
            Assert.assertEquals((Object)Key.SPACE, (Object)inc);
            inc = Key.findStartKey((int[])input, (int)1);
            Assert.assertEquals((Object)Key.UP, (Object)inc);
            inc = Key.findStartKey((int[])input, (int)4);
            Assert.assertEquals((Object)Key.ENTER, (Object)inc);
            input = new int[]{10};
            inc = Key.findStartKey((int[])input, (int)0);
            Assert.assertEquals((Object)Key.ENTER, (Object)inc);
        }
    }

    @Test
    public void testIsPrintable() {
        Assert.assertTrue((boolean)Key.a.isPrintable());
        Assert.assertTrue((boolean)Key.P.isPrintable());
        Assert.assertTrue((boolean)Key.RIGHT_CURLY_BRACKET.isPrintable());
        Assert.assertFalse((boolean)Key.BACKSPACE.isPrintable());
        Assert.assertTrue((boolean)Key.isPrintable((int[])new int[]{197}));
        Assert.assertTrue((boolean)Key.isPrintable((int[])new int[]{229}));
        if (!Config.isOSPOSIXCompatible()) {
            Assert.assertFalse((boolean)Key.isPrintable((int[])new int[]{Key.WINDOWS_ESC.getFirstValue()}));
        }
    }

    @Test
    public void testHomeEndKeysNotPrintable() {
        Assert.assertFalse((boolean)Key.HOME.isPrintable());
        Assert.assertFalse((boolean)Key.END.isPrintable());
    }
}

