/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.readline.Readline;
import org.jboss.aesh.readline.completion.Completion;
import org.jboss.aesh.terminal.formatting.CharacterType;
import org.jboss.aesh.terminal.formatting.Color;
import org.jboss.aesh.terminal.formatting.TerminalCharacter;
import org.jboss.aesh.terminal.formatting.TerminalColor;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.tty.terminal.TerminalConnection;
import org.jboss.aesh.util.LoggerUtil;

public class Example {
    private static final Logger LOGGER = LoggerUtil.getLogger(Example.class.getName());
    private static boolean masking = false;
    private static Prompt defaultPrompt;
    private static Thread sleeperThread;

    public static void main(String[] args) throws IOException {
        LoggerUtil.doLog();
        defaultPrompt = Example.createDefaultPrompt();
        Readline readline = new Readline();
        TerminalConnection connection = new TerminalConnection();
        connection.setSignalHandler(signal -> {
            if (signal == Signal.INT) {
                connection.write("we're catching ctrl-c, just continuing.\n");
                if (sleeperThread != null) {
                    sleeperThread.interrupt();
                }
            }
        });
        connection.setCloseHandler(close -> connection.write("we're shutting down, do something...!"));
        Example.readInput(connection, readline, new Prompt("[aesh@rules]$ "));
        connection.startBlockingReader();
    }

    public static void readInput(Connection connection, Readline readline, Prompt prompt) {
        readline.readline(connection, prompt, line -> {
            connection.write("=====> " + line + "\n");
            if (line == null) {
                connection.write("got eof, lets quit.\n");
                connection.close();
            } else if (masking) {
                connection.write("got password: " + line + ", stopping masking\n");
                masking = false;
                Example.readInput(connection, readline, defaultPrompt);
            } else {
                if (line.equals("quit") || line.equals("exit")) {
                    connection.write("we're quitting...\n");
                    connection.close();
                    return;
                }
                if (line.equals("sleep")) {
                    LOGGER.info("got sleep");
                    try {
                        connection.write("we're going to sleep for 5 seconds, you can interrupt me if you want.\n");
                        sleeperThread = Thread.currentThread();
                        Thread.sleep(5000L);
                        connection.write("done sleeping, returning.\n");
                        Example.readInput(connection, readline, defaultPrompt);
                    }
                    catch (InterruptedException e) {
                        connection.write("we got interrupted, lets continue...\n");
                        Example.readInput(connection, readline, defaultPrompt);
                    }
                } else if (line.equals("login")) {
                    masking = true;
                    Example.readInput(connection, readline, new Prompt("password: ", Character.valueOf('\u0000')));
                } else if (line.startsWith("man")) {
                    connection.write("trying to wait for input:\n");
                    Readline inputLine = new Readline();
                    inputLine.readline(connection, "write something: ", newLine -> {
                        connection.write("we got: " + newLine + "\n");
                        Example.readInput(connection, readline, prompt);
                    });
                } else {
                    Example.readInput(connection, readline, prompt);
                }
            }
        }, Example.getCompletions());
    }

    private static List<Completion> getCompletions() {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        completions.add(completeOperation -> {
            if ("exit".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("exit");
            }
            if ("quit".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("quit");
            }
            if ("sleep".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("sleep");
            }
            if ("login".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("login");
            }
            if ("man".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("man");
            }
        });
        return completions;
    }

    private static Prompt createDefaultPrompt() {
        ArrayList<TerminalCharacter> chars = new ArrayList<TerminalCharacter>();
        chars.add(new TerminalCharacter('[', new TerminalColor(Color.BLUE, Color.DEFAULT)));
        chars.add(new TerminalCharacter('t', new TerminalColor(Color.RED, Color.DEFAULT), CharacterType.ITALIC));
        chars.add(new TerminalCharacter('e', new TerminalColor(Color.RED, Color.DEFAULT), CharacterType.INVERT));
        chars.add(new TerminalCharacter('s', new TerminalColor(Color.RED, Color.DEFAULT), CharacterType.CROSSED_OUT));
        chars.add(new TerminalCharacter('t', new TerminalColor(Color.RED, Color.DEFAULT), CharacterType.BOLD));
        chars.add(new TerminalCharacter(']', new TerminalColor(Color.BLUE, Color.DEFAULT), CharacterType.FAINT));
        chars.add(new TerminalCharacter('$', new TerminalColor(Color.GREEN, Color.DEFAULT), CharacterType.UNDERLINE));
        chars.add(new TerminalCharacter(' ', new TerminalColor(Color.DEFAULT, Color.DEFAULT)));
        return new Prompt(chars);
    }
}

