/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jboss.aesh.readline.ActionDecoder;
import org.jboss.aesh.readline.KeyAction;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.readline.Readline;
import org.jboss.aesh.readline.ReadlineBuilder;
import org.jboss.aesh.readline.completion.CompleteOperation;
import org.jboss.aesh.readline.completion.Completion;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.terminal.TerminalConnection;

public class Shell {
    private TerminalConnection connection;
    private Readline readline;
    private Prompt prompt;
    private List<Completion> completions;
    private static Shell SHELL;
    private boolean directoryField;
    private boolean disableFileCompletion;
    private volatile String input;
    private volatile boolean lineRead = false;
    Completion fileCompleter = new Completion(){

        @Override
        public void complete(CompleteOperation co) {
            if (Shell.this.getDisableFileCompletion()) {
                return;
            }
        }
    };

    private Shell() {
        this.connection = new TerminalConnection();
        this.readline = ReadlineBuilder.builder().enableHistory(false).build();
        this.completions = new ArrayList<Completion>();
        this.completions.add(this.fileCompleter);
        this.prompt = new Prompt("[prompt]");
    }

    public static Shell getInstance() {
        if (SHELL == null) {
            SHELL = new Shell();
        }
        return SHELL;
    }

    public String getInput() {
        String[] line = new String[1];
        this.readline.readline((Connection)this.connection, this.prompt, input -> {
            line[0] = input;
            this.connection.stopReading();
        });
        this.connection.startBlockingReader();
        return line[0];
    }

    public String getLocation(boolean directoryField) {
        this.setDirectoryField(directoryField);
        String[] line = new String[1];
        this.readline.readline((Connection)this.connection, this.prompt, input -> {
            line[0] = input;
        }, this.completions);
        return line[0].replace("~", System.getProperty("user.home")).trim();
    }

    public String getPassword() {
        String[] line = new String[1];
        this.readline.readline((Connection)this.connection, new Prompt("", Character.valueOf('*')), input -> {
            line[0] = input;
            this.connection.stopReading();
        });
        this.connection.startBlockingReader();
        return line[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar() {
        KeyAction[] action = new KeyAction[1];
        ActionDecoder decoder = new ActionDecoder();
        CountDownLatch latch = new CountDownLatch(1);
        this.connection.setStdinHandler(ints -> {
            decoder.add((int[])ints);
            action[0] = decoder.next();
            this.connection.stopReading();
            latch.countDown();
        });
        this.connection.startBlockingReader();
        try {
            latch.await();
            if (action[0] instanceof Key) {
                if (((Key)action[0]).isPrintable()) {
                    char c = ((Key)action[0]).getAsChar();
                    return c;
                }
                char c = '\u0000';
                return c;
            }
            char c = (char)action[0].getCodePointAt(0);
            return c;
        }
        catch (InterruptedException e) {
            char c = '\u0000';
            return c;
        }
        finally {
            this.connection.setStdinHandler(null);
        }
    }

    private void setDirectoryField(boolean isDirectory) {
        this.directoryField = isDirectory;
    }

    private void setDisableFileCompletion(boolean disableFileCompletion) {
        this.disableFileCompletion = disableFileCompletion;
    }

    private boolean getDirectoryField() {
        return this.directoryField;
    }

    private boolean getDisableFileCompletion() {
        return this.disableFileCompletion;
    }

    private String getLastPathSection(String path) {
        if (path.endsWith(System.getProperty("file.separator"))) {
            return "";
        }
        String fileSeparator = System.getProperty("file.separator");
        if (fileSeparator.equals("\\")) {
            fileSeparator = fileSeparator.concat(fileSeparator);
        }
        String[] pathSegments = path.split(fileSeparator);
        String rest = "";
        if (pathSegments.length > 1) {
            rest = pathSegments[pathSegments.length - 1];
        }
        return rest;
    }

    public static void main(String[] args) {
        Shell shell = Shell.getInstance();
        System.out.println("trying to get a line:");
        String line = shell.getInput();
        System.out.println("we got: " + line + ", lets get a password..");
        String pass = shell.getPassword();
        System.out.println("password: " + pass + ", lets get a char: ");
        char in = shell.getChar();
        System.out.println("got char: " + in);
    }
}

