/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.readline.Readline;
import org.jboss.aesh.readline.completion.Completion;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.terminal.formatting.Color;
import org.jboss.aesh.terminal.formatting.TerminalColor;
import org.jboss.aesh.terminal.formatting.TerminalString;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.tty.terminal.TerminalConnection;
import org.jboss.aesh.util.LoggerUtil;

public class ShellExample {
    private static final Pattern splitter = Pattern.compile("\\w+");
    private static final Logger LOGGER = LoggerUtil.getLogger(ShellExample.class.getName());

    public static void main(String[] args) {
        LoggerUtil.doLog();
        TerminalConnection connection = new TerminalConnection();
        ShellExample shell = new ShellExample();
        shell.start(connection);
        connection.startBlockingReader();
    }

    public void start(Connection conn) {
        Readline readline = new Readline(EditModeBuilder.builder(EditMode.Mode.VI).create());
        this.read(conn, readline);
    }

    public void read(Connection conn, Readline readline) {
        Prompt prompt = new Prompt(new TerminalString("[aesh@rules]$ ", new TerminalColor(Color.GREEN, Color.DEFAULT, Color.Intensity.BRIGHT)));
        readline.readline(conn, prompt, line -> {
            if (line == null) {
                conn.write("logout\n").close();
                return;
            }
            LOGGER.info("got: " + line);
            Matcher matcher = splitter.matcher((CharSequence)line);
            if (matcher.find()) {
                String cmd = matcher.group();
                if (cmd.equals("exit")) {
                    conn.write("exiting...\n").close();
                    return;
                }
                ArrayList<String> args = new ArrayList<String>();
                while (matcher.find()) {
                    args.add(matcher.group());
                }
                try {
                    new Task(conn, readline, Command.valueOf(cmd), args).start();
                    return;
                }
                catch (IllegalArgumentException e) {
                    conn.write(line + ": command not found\n");
                }
            }
            this.read(conn, readline);
        }, this.getCompletions());
    }

    private List<Completion> getCompletions() {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        completions.add(completeOperation -> {
            if ("exit".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("exit");
            }
            if ("sleep".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("sleep");
            }
            if ("echo".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("echo");
            }
            if ("window".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("window");
            }
            if ("help".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("help");
            }
            if ("keyscan".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("keyscan");
            }
            if ("linescan".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("linescan");
            }
            if ("top".startsWith(completeOperation.getBuffer())) {
                completeOperation.addCompletionCandidate("top");
            }
        });
        return completions;
    }

    static enum Command {
        sleep{

            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                if (args.isEmpty()) {
                    conn.write("usage: sleep seconds\n");
                    return;
                }
                int time = -1;
                try {
                    time = Integer.parseInt(args.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (time > 0) {
                    Thread.sleep(time * 1000);
                }
            }
        }
        ,
        echo{

            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                for (int i = 0; i < args.size(); ++i) {
                    if (i > 0) {
                        conn.write(" ");
                    }
                    conn.write(args.get(i));
                }
                conn.write("\n");
            }
        }
        ,
        window{

            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                conn.write("Current window size " + conn.size() + ", try resize it\n");
                conn.setSizeHandler(size -> conn.write("Window resized " + size + "\n"));
                try {
                    new CountDownLatch(1).await();
                }
                finally {
                    conn.setSizeHandler(null);
                }
            }
        }
        ,
        help{

            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                StringBuilder msg = new StringBuilder("Demo term, try commands: ");
                Command[] commands = Command.values();
                for (int i = 0; i < commands.length; ++i) {
                    if (i > 0) {
                        msg.append(",");
                    }
                    msg.append(" ").append(commands[i].name());
                }
                msg.append("...\n");
                conn.write(msg.toString());
            }
        }
        ,
        keyscan{

            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                conn.setStdinHandler(keys -> {
                    for (int key : keys) {
                        conn.write(key + " pressed\n");
                    }
                });
                try {
                    new CountDownLatch(1).await();
                }
                finally {
                    conn.setStdinHandler(null);
                }
            }
        }
        ,
        linescan{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                CountDownLatch latch = new CountDownLatch(1);
                Readline readline = new Readline();
                readline.readline(conn, "[myprompt]: ", event -> {
                    conn.write("we got: " + event);
                    latch.countDown();
                });
                try {
                    latch.await();
                }
                finally {
                    conn.setStdinHandler(null);
                }
            }
        }
        ,
        top{

            @Override
            public void execute(Connection conn, List<String> args) throws Exception {
                while (true) {
                    StringBuilder buf = new StringBuilder();
                    Formatter formatter = new Formatter(buf);
                    ArrayList<Thread> threads = new ArrayList<Thread>(Thread.getAllStackTraces().keySet());
                    for (int i = 1; i <= conn.size().getHeight(); ++i) {
                        buf.append("\u001b[").append(i).append(";1H\u001b[K");
                        String format = "  %1$-5s %2$-10s %3$-50s %4$s";
                        if (i == 1) {
                            formatter.format(format, "ID", "STATE", "NAME", "GROUP");
                            continue;
                        }
                        int index = i - 2;
                        if (index >= threads.size()) continue;
                        Thread thread = (Thread)threads.get(index);
                        formatter.format(format, thread.getId(), thread.getState().name(), thread.getName(), thread.getThreadGroup().getName());
                    }
                    conn.write(buf.toString());
                    Thread.sleep(1000L);
                }
            }
        };


        abstract void execute(Connection var1, List<String> var2) throws Exception;
    }

    class Task
    extends Thread
    implements Consumer<Signal> {
        final Connection conn;
        final Readline readline;
        final Command command;
        final List<String> args;
        volatile boolean running;

        public Task(Connection conn, Readline readline, Command command, List<String> args) {
            this.conn = conn;
            this.readline = readline;
            this.command = command;
            this.args = args;
        }

        @Override
        public void accept(Signal signal) {
            switch (signal) {
                case INT: {
                    if (!this.running) break;
                    LOGGER.info("got interrupted in Task");
                    this.interrupt();
                }
            }
        }

        @Override
        public void run() {
            this.conn.setSignalHandler(this);
            this.running = true;
            try {
                this.command.execute(this.conn, this.args);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.running = false;
                this.conn.setSignalHandler(null);
                LOGGER.info("trying to read again.");
                ShellExample.this.read(this.conn, this.readline);
            }
        }
    }
}

