/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline;

import java.util.Arrays;
import java.util.logging.Logger;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.readline.Buffer;
import org.jboss.aesh.readline.BufferString;
import org.jboss.aesh.readline.ConsoleBuffer;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.readline.completion.CompletionHandler;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.history.History;
import org.jboss.aesh.readline.history.InMemoryHistory;
import org.jboss.aesh.readline.paste.PasteManager;
import org.jboss.aesh.readline.undo.UndoAction;
import org.jboss.aesh.readline.undo.UndoManager;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.Size;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.Config;
import org.jboss.aesh.util.LoggerUtil;

public class AeshConsoleBufferString
implements ConsoleBuffer {
    private EditMode editMode;
    private final BufferString buffer;
    private final Connection connection;
    private final UndoManager undoManager;
    private final PasteManager pasteManager;
    private final History history;
    private final CompletionHandler completionHandler;
    private Size size;
    private final boolean ansiMode;
    private final boolean isLogging = true;
    private static final int[] resetLineAndSetCursorToStart = Parser.toCodePoints(ANSI.CURSOR_SAVE + "\u001b[" + "0G" + "\u001b[" + "2K");
    private static final int[] MOVE_BACKWARD_AND_CLEAR = Parser.toCodePoints(" \u001b[1D");
    private static final int[] CLEAR_LINE = Parser.toCodePoints("\u001b[0G\u001b[2K");
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshConsoleBufferString.class.getName());

    public AeshConsoleBufferString(Connection connection, Prompt prompt, EditMode editMode, History history, CompletionHandler completionHandler, Size size, boolean ansi) {
        this.connection = connection;
        this.ansiMode = ansi;
        this.buffer = new BufferString(this.ansiMode, prompt);
        this.pasteManager = new PasteManager();
        this.undoManager = new UndoManager();
        if (history == null) {
            this.history = new InMemoryHistory();
        } else {
            this.history = history;
            this.history.enable();
        }
        this.completionHandler = completionHandler;
        this.size = size;
        this.editMode = editMode;
        LOGGER.info("prompt: " + Parser.fromCodePoints(this.buffer.getPrompt().getPromptAsString()));
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    @Override
    public CompletionHandler getCompleter() {
        return this.completionHandler;
    }

    @Override
    public void setSize(Size size) {
        this.size = size;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public Buffer getBuffer() {
        return null;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public PasteManager getPasteManager() {
        return this.pasteManager;
    }

    @Override
    public void moveCursor(int where) {
        if (this.ansiMode) {
            if (this.editMode.getMode() == EditMode.Mode.VI && (this.editMode.getStatus() == EditMode.Status.COMMAND || this.editMode.getStatus() == EditMode.Status.DELETE)) {
                this.write(this.buffer.move(where, this.size.getWidth(), true));
            } else {
                this.write(this.buffer.move(where, this.size.getWidth()));
            }
        }
    }

    @Override
    public void drawLine() {
        this.drawLine(true);
    }

    @Override
    public void drawLine(boolean keepCursorPosition) {
        this.drawLine(keepCursorPosition, true);
    }

    @Override
    public void drawLine(boolean keepCursorPosition, boolean optimize) {
        LOGGER.info("drawing: " + Parser.fromCodePoints(this.buffer.getPrompt().getPromptAsString()) + this.buffer.getLine());
        if (!this.ansiMode) {
            this.connection.stdoutHandler().accept(Config.CR);
            this.connection.stdoutHandler().accept(this.buffer.getPrompt().getPromptAsString());
            this.connection.write(this.buffer.getLine());
            return;
        }
        if (this.buffer.totalLength() > this.size.getWidth() || this.buffer.getDelta() < 0 && this.buffer.totalLength() + Math.abs(this.buffer.getDelta()) > this.size.getWidth()) {
            if (this.buffer.getDelta() == -1 && this.buffer.getCursor() >= this.buffer.length() && Config.isOSPOSIXCompatible()) {
                this.connection.stdoutHandler().accept(MOVE_BACKWARD_AND_CLEAR);
            } else {
                this.redrawMultipleLines(keepCursorPosition);
            }
        } else if (this.buffer.getDelta() == -1 && this.buffer.getCursor() >= this.buffer.length() && optimize) {
            this.connection.stdoutHandler().accept(MOVE_BACKWARD_AND_CLEAR);
        } else {
            if (keepCursorPosition) {
                this.connection.stdoutHandler().accept(resetLineAndSetCursorToStart);
            }
            if (!this.buffer.isPromptDisabled()) {
                this.writeOut(CLEAR_LINE);
            }
            if (keepCursorPosition) {
                this.connection.write(this.buffer.getLine() + ANSI.CURSOR_RESTORE);
            } else {
                this.connection.write(this.buffer.getLine());
                this.buffer.setCursor(this.buffer.getLine().length());
            }
        }
    }

    private void redrawMultipleLines(boolean keepCursorPosition) {
        if (this.buffer.getDelta() == 0) {
            return;
        }
        int currentRow = 0;
        if (this.buffer.getCursorWithPrompt() > 0) {
            currentRow = this.buffer.getCursorWithPrompt() / this.size.getWidth();
        }
        if (currentRow > 0 && this.buffer.getCursorWithPrompt() % this.size.getWidth() == 0) {
            --currentRow;
        }
        LOGGER.info("actual position: " + this.buffer.getCursor());
        LOGGER.info("currentRow:" + currentRow + ", cursorWithPrompt:" + this.buffer.getCursorWithPrompt() + ", width:" + this.size.getWidth() + ", height:" + this.size.getHeight() + ", delta:" + this.buffer.getDelta() + ", buffer:" + this.buffer.getLine());
        StringBuilder builder = new StringBuilder();
        if (keepCursorPosition) {
            builder.append(ANSI.CURSOR_SAVE);
        }
        if (this.buffer.getDelta() > 0) {
            currentRow = (this.buffer.getCursorWithPrompt() - this.buffer.getDelta()) / this.size.getWidth();
            if (currentRow > 0 && (this.buffer.getCursorWithPrompt() - this.buffer.getDelta()) % this.size.getWidth() == 0) {
                --currentRow;
            }
            if (currentRow > 0) {
                for (int i = 0; i < currentRow; ++i) {
                    builder.append(BufferString.printAnsi('A'));
                }
            }
        } else {
            this.clearDelta(currentRow, builder);
        }
        builder.append(BufferString.printAnsi('0', 'G'));
        if (!this.buffer.isPromptDisabled()) {
            if (this.buffer.getPrompt().hasANSI()) {
                builder.append(Parser.fromCodePoints(this.buffer.getPrompt().getANSI()));
            } else {
                builder.append(Parser.fromCodePoints(this.buffer.getPrompt().getPromptAsString()));
            }
        }
        builder.append(this.buffer.getLine());
        if (this.buffer.getDelta() < 0) {
            builder.append(BufferString.printAnsi('K'));
        }
        if (keepCursorPosition) {
            builder.append(ANSI.CURSOR_RESTORE);
            this.connection.write(builder.toString());
        } else {
            this.connection.write(builder.toString());
            this.buffer.setCursor(this.buffer.getLine().length());
        }
    }

    private void clearDelta(int currentRow, StringBuilder builder) {
        if (this.buffer.getDelta() < 0) {
            int tmpCurrentRow;
            int currentLength = this.buffer.totalLength();
            if (currentLength > 1) {
                --currentLength;
            }
            int numberOfCurrentRows = currentLength / this.size.getWidth();
            int numberOfPrevRows = (currentLength + this.buffer.getDelta() * -1) / this.size.getWidth();
            int numberOfRowsToRemove = numberOfPrevRows - numberOfCurrentRows;
            int numberofRows = (this.buffer.getDelta() * -1 + this.buffer.totalLength()) / this.size.getWidth();
            if (numberOfRowsToRemove == 0) {
                ++numberOfRowsToRemove;
            }
            for (tmpCurrentRow = currentRow; tmpCurrentRow < numberofRows; ++tmpCurrentRow) {
                builder.append(ANSI.printAnsi('B'));
            }
            while (tmpCurrentRow > 0) {
                if (numberOfRowsToRemove > 0) {
                    builder.append(BufferString.printAnsi('2', 'K'));
                    --numberOfRowsToRemove;
                }
                builder.append(BufferString.printAnsi('A'));
                --tmpCurrentRow;
            }
        }
    }

    @Override
    public void writeOut(String out) {
        this.connection.write(out);
    }

    @Override
    public void writeOut(int[] out) {
        this.connection.stdoutHandler().accept(out);
    }

    @Override
    public void writeChars(int[] chars) {
        for (int c : chars) {
            this.writeChar((char)c);
        }
    }

    @Override
    public void writeString(String input) {
        for (char c : input.toCharArray()) {
            this.writeChar(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeChar(char c) {
        this.buffer.write(c);
        if (this.buffer.getPrompt().isMasking()) {
            if (this.buffer.getPrompt().getMask().charValue() == '\u0000') return;
            this.write(this.buffer.getPrompt().getMask().charValue());
        } else {
            this.write(c);
        }
        if (this.buffer.getCursorWithPrompt() > this.size.getWidth() && this.buffer.getCursorWithPrompt() % this.size.getWidth() == 1) {
            this.connection.stdoutHandler().accept(new int[]{32, 13});
        }
        if (!this.ansiMode) {
            return;
        }
        if (this.buffer.getCursor() >= this.buffer.length()) return;
        if (this.buffer.totalLength() > this.size.getWidth() && (this.buffer.totalLength() - 1) % this.size.getWidth() == 1) {
            int totalRows;
            int currentRow = this.buffer.getCursorWithPrompt() / this.size.getWidth();
            if (currentRow > 0 && this.buffer.getCursorWithPrompt() % this.size.getWidth() == 0) {
                --currentRow;
            }
            if ((totalRows = this.buffer.totalLength() / this.size.getWidth()) > 0 && this.buffer.totalLength() % this.size.getWidth() == 0) {
                --totalRows;
            }
        }
        this.drawLine();
    }

    private void write(char c) {
        this.connection.stdoutHandler().accept(new int[]{c});
    }

    private void write(char[] chars) {
        LOGGER.info("writing to stdout: " + Arrays.toString(chars));
        int[] out = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            out[i] = chars[i];
        }
        this.connection.stdoutHandler().accept(out);
    }

    @Override
    public void setPrompt(Prompt prompt) {
        if (!this.buffer.getPrompt().equals(prompt)) {
            this.buffer.updatePrompt(prompt);
            if (this.ansiMode) {
                this.connection.stdoutHandler().accept(CLEAR_LINE);
                this.displayPrompt(prompt);
                if (this.buffer.getLine().length() > 0) {
                    this.connection.write(this.buffer.getLine());
                    this.buffer.setCursor(this.buffer.getLine().length());
                }
            }
        }
    }

    @Override
    public void setBufferLine(String newLine) {
        int currentRow;
        if (newLine.length() + this.buffer.getPrompt().getLength() >= this.size.getWidth() && newLine.length() >= this.buffer.getLine().length() && (currentRow = this.buffer.getCursor() / this.size.getWidth()) > -1) {
            int cursorRow = this.buffer.getCursorWithPrompt() / this.size.getWidth();
            if (currentRow + newLine.length() / this.size.getWidth() - cursorRow >= this.size.getHeight()) {
                int numNewRows = currentRow + (newLine.length() + this.buffer.getPrompt().getLength()) / this.size.getWidth() - cursorRow - this.size.getHeight();
                if ((newLine.length() + this.buffer.getPrompt().getLength()) % this.size.getWidth() == 0) {
                    ++numNewRows;
                }
                if (numNewRows > 0) {
                    int totalRows = (newLine.length() + this.buffer.getPrompt().getLength()) / this.size.getWidth() + 1;
                    LOGGER.info("ADDING " + numNewRows + ", totalRows:" + totalRows + ", currentRow:" + currentRow + ", cursorRow:" + cursorRow);
                    this.write(BufferString.printAnsi((char)numNewRows, 'S'));
                    this.write(BufferString.printAnsi((char)numNewRows, 'A'));
                }
            }
        }
        this.buffer.setLine(newLine);
    }

    @Override
    public void insertBufferLine(String insert, int position) {
        int currentRow;
        if (insert.length() + this.buffer.totalLength() >= this.size.getWidth() && (currentRow = this.buffer.getCursor() / this.size.getWidth()) > -1) {
            int newLine = insert.length() + this.buffer.totalLength();
            int cursorRow = this.buffer.getCursorWithPrompt() / this.size.getWidth();
            if (currentRow + newLine / this.size.getWidth() - cursorRow >= this.size.getHeight()) {
                int numNewRows = currentRow + newLine / this.size.getWidth() - cursorRow - this.size.getHeight();
                if ((insert.length() + this.buffer.totalLength()) % this.size.getWidth() == 0) {
                    ++numNewRows;
                }
                if (numNewRows > 0) {
                    this.write(BufferString.printAnsi((char)numNewRows, 'S'));
                    this.write(BufferString.printAnsi((char)numNewRows, 'A'));
                }
            }
        }
        this.buffer.insert(position, insert);
    }

    @Override
    public void delete(int delta) {
    }

    @Override
    public void upCase() {
    }

    @Override
    public void downCase() {
    }

    @Override
    public void changeCase() {
    }

    @Override
    public void replace(int[] line) {
    }

    @Override
    public void replace(String line) {
    }

    private void displayPrompt(Prompt prompt) {
        if (prompt.hasANSI() && this.ansiMode) {
            this.connection.stdoutHandler().accept(prompt.getANSI());
        } else {
            this.connection.stdoutHandler().accept(prompt.getPromptAsString());
        }
    }

    @Override
    public void addActionToUndoStack() {
        UndoAction ua = new UndoAction(this.buffer.getCursor(), this.buffer.getLine());
        this.undoManager.addUndo(ua);
    }

    private void addToPaste(String buffer) {
        this.pasteManager.addText(new StringBuilder(buffer));
    }

    @Override
    public void clear(boolean includeBuffer) {
        if (this.ansiMode) {
            if (!Config.isOSPOSIXCompatible()) {
                this.connection.stdoutHandler().accept(Config.CR);
            }
            this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
            this.connection.stdoutHandler().accept(new int[]{27, 91, 49, 59, 49, 72});
            if (includeBuffer) {
                this.connection.write(this.buffer.getLine());
            }
        }
    }
}

