/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline;

import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jboss.aesh.readline.Action;
import org.jboss.aesh.readline.ActionDecoder;
import org.jboss.aesh.readline.AeshConsoleBuffer;
import org.jboss.aesh.readline.ConsoleBuffer;
import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.KeyAction;
import org.jboss.aesh.readline.Prompt;
import org.jboss.aesh.readline.completion.Completion;
import org.jboss.aesh.readline.completion.CompletionHandler;
import org.jboss.aesh.readline.completion.SimpleCompletionHandler;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.readline.history.History;
import org.jboss.aesh.readline.history.InMemoryHistory;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.tty.Connection;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.tty.Size;
import org.jboss.aesh.util.Config;
import org.jboss.aesh.util.LoggerUtil;

public class Readline {
    private static final Logger LOGGER = LoggerUtil.getLogger(Readline.class.getName());
    private final ActionDecoder decoder;
    private AeshInputProcessor inputProcessor;
    private Size size;
    private CompletionHandler completionHandler;
    private EditMode editMode;
    private History history;

    public Readline() {
        this(EditModeBuilder.builder().create());
    }

    public Readline(EditMode editMode) {
        this(editMode, new InMemoryHistory(), null);
    }

    public Readline(EditMode editMode, History history, CompletionHandler completionHandler) {
        this.editMode = editMode;
        this.history = history;
        this.completionHandler = completionHandler;
        this.decoder = new ActionDecoder(this.editMode);
    }

    protected InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    private void readInput() {
        while (this.decoder.hasNext() && this.inputProcessor != null && !this.inputProcessor.paused) {
            this.inputProcessor.parse(this.decoder.next());
        }
    }

    public void readline(Connection conn, String prompt, Consumer<String> requestHandler) {
        this.readline(conn, new Prompt(prompt), requestHandler, null);
    }

    public void readline(Connection conn, String prompt, Consumer<String> requestHandler, List<Completion> completions) {
        this.readline(conn, new Prompt(prompt), requestHandler, completions);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler) {
        this.readline(conn, prompt, requestHandler, null);
    }

    public void readline(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions) {
        if (this.inputProcessor != null) {
            throw new IllegalStateException("Already reading a line");
        }
        this.inputProcessor = new AeshInputProcessor(conn, prompt, requestHandler, completions);
        this.inputProcessor.start();
        this.processInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInput() {
        Readline readline = this;
        synchronized (readline) {
            if (this.inputProcessor == null) {
                throw new IllegalStateException("No inputProcessor!");
            }
            if (!this.decoder.hasNext()) {
                return;
            }
            this.readInput();
        }
    }

    public class AeshInputProcessor
    implements InputProcessor {
        private final Connection conn;
        private Consumer<int[]> prevReadHandler;
        private Consumer<Size> prevSizeHandler;
        private Consumer<Signal> prevEventHandler;
        private final Consumer<String> requestHandler;
        private boolean paused;
        private final ConsoleBuffer consoleBuffer;
        private String returnValue;

        private AeshInputProcessor(Connection conn, Prompt prompt, Consumer<String> requestHandler, List<Completion> completions) {
            Readline.this.completionHandler = new SimpleCompletionHandler();
            Readline.this.completionHandler.addCompletions(completions);
            this.consoleBuffer = new AeshConsoleBuffer(conn, prompt, Readline.this.editMode, Readline.this.history, Readline.this.completionHandler, Readline.this.size, true);
            this.conn = conn;
            this.requestHandler = requestHandler;
        }

        private void finish(String s) {
            this.conn.setStdinHandler(this.prevReadHandler);
            this.conn.setSizeHandler(this.prevSizeHandler);
            this.conn.setSignalHandler(this.prevEventHandler);
            Readline.this.inputProcessor = null;
            this.requestHandler.accept(s);
        }

        private void parse(KeyAction event) {
            if (event.length() == 1 && event.getCodePointAt(0) == 4 && this.getBuffer().getBuffer().length() == 0) {
                this.finish(null);
                return;
            }
            Action action = Readline.this.editMode.parse(event);
            if (action != null) {
                this.paused = true;
                action.apply(this);
                if (this.getReturnValue() != null) {
                    this.conn.stdoutHandler().accept(Config.CR);
                    this.finish(this.getReturnValue());
                } else {
                    this.paused = false;
                    Readline.this.processInput();
                }
            } else if (Key.isPrintable(event.buffer().array()) && this.notInCommandNode()) {
                this.getBuffer().writeChar((char)event.buffer().array()[0]);
            }
        }

        private boolean notInCommandNode() {
            return Readline.this.editMode.getMode() != EditMode.Mode.VI || Readline.this.editMode.getStatus() != EditMode.Status.COMMAND;
        }

        public final Size size() {
            return Readline.this.size;
        }

        private void start() {
            this.prevReadHandler = this.conn.getStdinHandler();
            this.prevSizeHandler = this.conn.getSizeHandler();
            this.prevEventHandler = this.conn.getSignalHandler();
            this.conn.setStdinHandler(data -> {
                Readline.this.decoder.add((int[])data);
                Readline.this.readInput();
            });
            Readline.this.size = this.conn.size();
            if (Readline.this.size == null) {
                throw new RuntimeException("Terminal size must not be null");
            }
            this.consoleBuffer.setSize(Readline.this.size);
            this.conn.setSizeHandler(dim -> {
                if (Readline.this.size != null) {
                    this.resize((Size)dim);
                }
                Readline.this.size = dim;
            });
            this.conn.setSignalHandler(signal -> {
                if (signal == Signal.INT) {
                    if (Readline.this.editMode.isInChainedAction()) {
                        this.parse(Key.CTRL_C);
                    } else {
                        this.conn.stdoutHandler().accept(new int[]{94, 67, 10});
                        this.conn.stdoutHandler().accept(this.getBuffer().getBuffer().getPrompt().getANSI());
                        this.getBuffer().getBuffer().reset();
                    }
                }
            });
            this.consoleBuffer.drawLine();
        }

        private void resize(Size size) {
            this.consoleBuffer.setSize(size);
            this.consoleBuffer.drawLine();
        }

        @Override
        public String getReturnValue() {
            return this.returnValue;
        }

        @Override
        public ConsoleBuffer getBuffer() {
            return this.consoleBuffer;
        }

        @Override
        public void setReturnValue(String value) {
            this.returnValue = value;
        }

        @Override
        public EditMode getEditMode() {
            return Readline.this.editMode;
        }
    }
}

