/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline;

import java.io.File;
import org.jboss.aesh.readline.Readline;
import org.jboss.aesh.readline.completion.CompletionHandler;
import org.jboss.aesh.readline.completion.SimpleCompletionHandler;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.EditModeBuilder;
import org.jboss.aesh.readline.history.FileHistory;
import org.jboss.aesh.readline.history.History;
import org.jboss.aesh.readline.history.InMemoryHistory;

public class ReadlineBuilder {
    private EditMode editMode;
    private History history;
    private CompletionHandler completionHandler;
    private int historySize = 50;
    private String historyFile;
    private boolean enableHistory = true;

    public static ReadlineBuilder builder() {
        return new ReadlineBuilder();
    }

    private ReadlineBuilder() {
    }

    public ReadlineBuilder editMode(EditMode editMode) {
        this.editMode = editMode;
        return this;
    }

    public ReadlineBuilder history(History history) {
        this.history = history;
        return this;
    }

    public ReadlineBuilder enableHistory(boolean history) {
        this.enableHistory = history;
        return this;
    }

    public ReadlineBuilder historySize(int historySize) {
        this.historySize = historySize;
        return this;
    }

    public ReadlineBuilder historyFile(String historyFile) {
        this.historyFile = historyFile;
        return this;
    }

    public ReadlineBuilder completionHandler(CompletionHandler completionHandler) {
        this.completionHandler = completionHandler;
        return this;
    }

    public Readline build() {
        if (this.editMode == null) {
            this.editMode = EditModeBuilder.builder().create();
        }
        if (!this.enableHistory) {
            this.history = null;
        } else if (this.history == null) {
            this.history = this.historyFile == null || !new File(this.historyFile).isFile() ? new InMemoryHistory(this.historySize) : new FileHistory(new File(this.historyFile), this.historySize);
        }
        if (this.completionHandler == null) {
            this.completionHandler = new SimpleCompletionHandler();
        }
        return new Readline(this.editMode, this.history, this.completionHandler);
    }
}

