/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.actions;

import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.actions.ChangeAction;
import org.jboss.aesh.readline.editing.EditMode;

abstract class BackwardWord
extends ChangeAction {
    private boolean viMode;

    public BackwardWord() {
        super(EditMode.Status.MOVE);
        this.viMode = false;
    }

    public BackwardWord(boolean viMode, EditMode.Status status) {
        super(status);
        this.viMode = viMode;
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        int cursor = inputProcessor.getBuffer().getBuffer().getCursor();
        if (cursor > inputProcessor.getBuffer().getBuffer().length()) {
            cursor = inputProcessor.getBuffer().getBuffer().length() - 1;
        }
        if (this.viMode) {
            String buffer = inputProcessor.getBuffer().getBuffer().getLineAsString();
            while (cursor > 0 && this.isSpace(buffer.charAt(cursor - 1))) {
                --cursor;
            }
            if (cursor > 0 && this.isDelimiter(buffer.charAt(cursor - 1))) {
                while (cursor > 0 && this.isDelimiter(buffer.charAt(cursor - 1)) && !this.isSpace(buffer.charAt(cursor - 1))) {
                    --cursor;
                }
            } else {
                while (cursor > 0 && !this.isDelimiter(buffer.charAt(cursor - 1))) {
                    --cursor;
                }
            }
        } else {
            String buffer = inputProcessor.getBuffer().getBuffer().getLineAsString();
            while (cursor > 0 && this.isDelimiter(buffer.charAt(cursor - 1))) {
                --cursor;
            }
            while (cursor > 0 && !this.isDelimiter(buffer.charAt(cursor - 1))) {
                --cursor;
            }
        }
        this.apply(cursor, inputProcessor);
    }
}

