/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.actions;

import java.util.logging.Logger;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.actions.MovementAction;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.undo.UndoAction;
import org.jboss.aesh.util.LoggerUtil;

abstract class ChangeAction
extends MovementAction {
    private EditMode.Status status;
    protected boolean viMode;
    private static final Logger LOGGER = LoggerUtil.getLogger(ChangeAction.class.getName());

    ChangeAction(EditMode.Status status) {
        this.status = status;
        this.viMode = false;
    }

    ChangeAction(boolean viMode, EditMode.Status status) {
        this.status = status;
        this.viMode = viMode;
    }

    protected EditMode.Status getStatus() {
        return this.status;
    }

    protected final void apply(int cursor, InputProcessor inputProcessor) {
        this.apply(cursor, inputProcessor.getBuffer().getBuffer().getCursor(), inputProcessor);
    }

    protected final void apply(int cursor, int oldCursor, InputProcessor inputProcessor) {
        String word;
        LOGGER.info("applying " + (Object)((Object)this.status) + " delta: " + cursor + ", current pos: " + oldCursor);
        if (this.status == EditMode.Status.DELETE || this.status == EditMode.Status.CHANGE) {
            this.addActionToUndoStack(inputProcessor);
            if (cursor < oldCursor) {
                inputProcessor.getBuffer().getPasteManager().addText(new StringBuilder(inputProcessor.getBuffer().getBuffer().getLineAsString().substring(cursor, oldCursor)));
                LOGGER.info("buffer before delete: " + inputProcessor.getBuffer().getBuffer().getLineAsString());
                inputProcessor.getBuffer().delete(cursor - oldCursor);
                LOGGER.info("buffer after delete: " + inputProcessor.getBuffer().getBuffer().getLineAsString());
                inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
            } else {
                inputProcessor.getBuffer().getPasteManager().addText(new StringBuilder(inputProcessor.getBuffer().getBuffer().getLineAsString().substring(oldCursor, cursor)));
                inputProcessor.getBuffer().delete(cursor - oldCursor);
            }
            if (this.viMode && this.status == EditMode.Status.DELETE && oldCursor == inputProcessor.getBuffer().getBuffer().length()) {
                inputProcessor.getBuffer().moveCursor(-1);
            }
        } else if (this.status == EditMode.Status.MOVE) {
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.YANK) {
            if (cursor < oldCursor) {
                inputProcessor.getBuffer().getPasteManager().addText(new StringBuilder(inputProcessor.getBuffer().getBuffer().getLineAsString().substring(cursor, oldCursor)));
            } else if (cursor > oldCursor) {
                inputProcessor.getBuffer().getPasteManager().addText(new StringBuilder(inputProcessor.getBuffer().getBuffer().getLineAsString().substring(oldCursor, cursor)));
            }
        } else if (this.status == EditMode.Status.UP_CASE) {
            if (cursor < oldCursor) {
                this.addActionToUndoStack(inputProcessor);
                for (int i = cursor; i < oldCursor; ++i) {
                    inputProcessor.getBuffer().upCase();
                }
            } else {
                this.addActionToUndoStack(inputProcessor);
                for (int i = oldCursor; i < cursor; ++i) {
                    inputProcessor.getBuffer().upCase();
                }
            }
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.DOWN_CASE) {
            if (cursor < oldCursor) {
                this.addActionToUndoStack(inputProcessor);
                for (int i = cursor; i < oldCursor; ++i) {
                    inputProcessor.getBuffer().downCase();
                }
            } else {
                this.addActionToUndoStack(inputProcessor);
                for (int i = oldCursor; i < cursor; ++i) {
                    inputProcessor.getBuffer().downCase();
                }
            }
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.CAPITALIZE && (word = Parser.findWordClosestToCursor(inputProcessor.getBuffer().getBuffer().getLineAsString(), oldCursor)).length() > 0) {
            this.addActionToUndoStack(inputProcessor);
            int pos = inputProcessor.getBuffer().getBuffer().getLineAsString().indexOf(word, oldCursor - word.length());
            if (pos < 0) {
                pos = 0;
            }
            inputProcessor.getBuffer().upCase();
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        }
    }

    protected final void addActionToUndoStack(InputProcessor inputProcessor) {
        inputProcessor.getBuffer().getUndoManager().addUndo(new UndoAction(inputProcessor.getBuffer().getBuffer().getCursor(), inputProcessor.getBuffer().getBuffer().getLineAsString()));
    }
}

