/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.actions;

import org.jboss.aesh.readline.Action;
import org.jboss.aesh.readline.ConsoleBuffer;
import org.jboss.aesh.readline.InputProcessor;

public class DeleteChar
implements Action {
    private boolean viMode = false;

    public DeleteChar() {
    }

    public DeleteChar(boolean viMode) {
        this.viMode = viMode;
    }

    @Override
    public String name() {
        return "delete-char";
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        this.deleteNoMasking(inputProcessor.getBuffer());
    }

    private void deleteNoMasking(ConsoleBuffer consoleBuffer) {
        int lineSize;
        int cursor = consoleBuffer.getBuffer().getCursor();
        if (cursor < (lineSize = consoleBuffer.getBuffer().length())) {
            consoleBuffer.addActionToUndoStack();
            consoleBuffer.getPasteManager().addText(new StringBuilder(consoleBuffer.getBuffer().getLineAsString().substring(cursor, cursor + 1)));
            consoleBuffer.delete(1);
            if (cursor == lineSize - 1 && cursor > 0 && this.viMode) {
                consoleBuffer.moveCursor(-1);
            }
        }
    }
}

