/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.actions;

import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.actions.ChangeAction;
import org.jboss.aesh.readline.editing.EditMode;

abstract class ForwardWord
extends ChangeAction {
    private boolean viMode;
    private boolean removeTrailingSpaces;

    ForwardWord() {
        super(EditMode.Status.MOVE);
        this.viMode = false;
    }

    ForwardWord(boolean viMode, EditMode.Status status) {
        super(status);
        this.viMode = viMode;
        this.removeTrailingSpaces = status != EditMode.Status.CHANGE;
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        int cursor;
        String buffer = inputProcessor.getBuffer().getBuffer().getLineAsString();
        if (this.viMode) {
            if (cursor < buffer.length() && this.isDelimiter(buffer.charAt(cursor))) {
                for (cursor = inputProcessor.getBuffer().getBuffer().getCursor(); cursor < buffer.length() && this.isDelimiter(buffer.charAt(cursor)); ++cursor) {
                }
            } else {
                while (cursor < buffer.length() && !this.isDelimiter(buffer.charAt(cursor))) {
                    ++cursor;
                }
                if (this.removeTrailingSpaces && cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
                    while (cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
                        ++cursor;
                    }
                }
            }
        } else {
            while (cursor < buffer.length() && this.isDelimiter(buffer.charAt(cursor))) {
                ++cursor;
            }
            while (cursor < buffer.length() && !this.isDelimiter(buffer.charAt(cursor))) {
                ++cursor;
            }
        }
        if (this.removeTrailingSpaces && cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
            while (cursor < buffer.length() && this.isSpace(buffer.charAt(cursor))) {
                ++cursor;
            }
        }
        this.apply(cursor, inputProcessor);
    }
}

