/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.actions;

import java.util.logging.Logger;
import org.jboss.aesh.readline.Action;
import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.KeyAction;
import org.jboss.aesh.readline.SearchAction;
import org.jboss.aesh.readline.actions.BackwardChar;
import org.jboss.aesh.readline.actions.DeletePrevChar;
import org.jboss.aesh.readline.actions.Enter;
import org.jboss.aesh.readline.actions.ForwardChar;
import org.jboss.aesh.readline.actions.ForwardSearchHistory;
import org.jboss.aesh.readline.actions.Interrupt;
import org.jboss.aesh.readline.actions.NextHistory;
import org.jboss.aesh.readline.actions.PrevHistory;
import org.jboss.aesh.readline.actions.ReverseSearchHistory;
import org.jboss.aesh.readline.history.SearchDirection;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.LoggerUtil;

abstract class SearchHistory
implements SearchAction {
    private SearchAction.Status status = SearchAction.Status.SEARCH_NOT_STARTED;
    private StringBuilder searchArgument;
    private String searchResult;
    private SearchAction.Status defaultAction;
    private static final Logger LOGGER = LoggerUtil.getLogger(SearchHistory.class.getName());

    SearchHistory(SearchAction.Status defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public void input(Action action, KeyAction key) {
        if (action == null && Key.isPrintable(key.buffer().array())) {
            if (this.searchArgument == null) {
                this.searchArgument = new StringBuilder();
            }
            this.status = this.defaultAction;
            this.searchArgument.append((char)key.buffer().array()[0]);
        } else if (action instanceof Interrupt) {
            this.status = SearchAction.Status.SEARCH_INTERRUPT;
        } else if (action instanceof Enter) {
            this.status = SearchAction.Status.SEARCH_END;
        } else if (action instanceof ReverseSearchHistory) {
            this.status = SearchAction.Status.SEARCH_PREV;
        } else if (action instanceof ForwardSearchHistory) {
            this.status = SearchAction.Status.SEARCH_NEXT;
        } else if (action instanceof DeletePrevChar) {
            this.status = SearchAction.Status.SEARCH_DELETE;
        } else if (action instanceof PrevHistory) {
            this.status = SearchAction.Status.SEARCH_MOVE_PREV;
        } else if (action instanceof NextHistory) {
            this.status = SearchAction.Status.SEARCH_MOVE_NEXT;
        } else if (action instanceof ForwardChar) {
            this.status = SearchAction.Status.SEARCH_MOVE_RIGHT;
        } else if (action instanceof BackwardChar) {
            this.status = SearchAction.Status.SEARCH_MOVE_LEFT;
        } else {
            if (key == Key.ESC) {
                this.status = SearchAction.Status.SEARCH_EXIT;
            }
            if (Key.isPrintable(key.buffer().array())) {
                if (this.searchArgument == null) {
                    this.searchArgument = new StringBuilder();
                }
                this.status = this.defaultAction;
                this.searchArgument.append((char)key.buffer().array()[0]);
            }
        }
    }

    @Override
    public boolean keepFocus() {
        return this.status == SearchAction.Status.SEARCH_INPUT || this.status == SearchAction.Status.SEARCH_PREV || this.status == SearchAction.Status.SEARCH_NEXT || this.status == SearchAction.Status.SEARCH_DELETE;
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        if (this.status == SearchAction.Status.SEARCH_INTERRUPT) {
            inputProcessor.getBuffer().setBufferLine("");
            this.searchArgument = null;
            this.searchResult = null;
        } else {
            switch (this.status) {
                case SEARCH_PREV: {
                    if (inputProcessor.getBuffer().getHistory().getSearchDirection() != SearchDirection.REVERSE) {
                        inputProcessor.getBuffer().getHistory().setSearchDirection(SearchDirection.REVERSE);
                    }
                    if (this.searchArgument == null || this.searchArgument.length() <= 0) break;
                    String tmpResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toString());
                    if (tmpResult == null) {
                        this.searchArgument.deleteCharAt(this.searchArgument.length() - 1);
                        break;
                    }
                    this.searchResult = tmpResult;
                    break;
                }
                case SEARCH_NEXT: {
                    if (inputProcessor.getBuffer().getHistory().getSearchDirection() != SearchDirection.FORWARD) {
                        inputProcessor.getBuffer().getHistory().setSearchDirection(SearchDirection.FORWARD);
                    }
                    if (this.searchArgument == null || this.searchArgument.length() <= 0) break;
                    String tmpResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toString());
                    if (tmpResult == null) {
                        this.searchArgument.deleteCharAt(this.searchArgument.length() - 1);
                        break;
                    }
                    this.searchResult = tmpResult;
                    break;
                }
                case SEARCH_NOT_STARTED: {
                    this.status = SearchAction.Status.SEARCH_PREV;
                    inputProcessor.getBuffer().getHistory().setSearchDirection(SearchDirection.REVERSE);
                    if (inputProcessor.getBuffer().getBuffer().length() <= 0) break;
                    this.searchArgument = new StringBuilder(inputProcessor.getBuffer().getBuffer().getLineAsString());
                    this.searchResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toString());
                    break;
                }
                case SEARCH_DELETE: {
                    if (this.searchArgument == null || this.searchArgument.length() <= 0) break;
                    this.searchArgument.deleteCharAt(this.searchArgument.length() - 1);
                    this.searchResult = inputProcessor.getBuffer().getHistory().search(this.searchArgument.toString());
                    break;
                }
                case SEARCH_END: {
                    if (this.searchResult != null) {
                        inputProcessor.getBuffer().moveCursor(-inputProcessor.getBuffer().getBuffer().getCursor());
                        inputProcessor.getBuffer().setBufferLine(this.searchResult);
                        inputProcessor.getBuffer().getHistory().push(inputProcessor.getBuffer().getBuffer().getLineAsString());
                        inputProcessor.getBuffer().getBuffer().reset();
                        inputProcessor.setReturnValue(this.searchResult);
                        break;
                    }
                    inputProcessor.getBuffer().moveCursor(-inputProcessor.getBuffer().getBuffer().getCursor());
                    inputProcessor.getBuffer().setBufferLine("");
                    break;
                }
                case SEARCH_EXIT: {
                    if (this.searchResult != null) {
                        inputProcessor.getBuffer().setBufferLine(this.searchResult);
                        break;
                    }
                    inputProcessor.getBuffer().setBufferLine("");
                    break;
                }
                case SEARCH_MOVE_NEXT: {
                    this.searchResult = inputProcessor.getBuffer().getHistory().getNextFetch();
                    inputProcessor.getBuffer().setBufferLine(this.searchResult);
                    break;
                }
                case SEARCH_MOVE_PREV: {
                    this.searchResult = inputProcessor.getBuffer().getHistory().getPreviousFetch();
                    inputProcessor.getBuffer().setBufferLine(this.searchResult);
                    break;
                }
                case SEARCH_MOVE_RIGHT: {
                    inputProcessor.getBuffer().setBufferLine(this.searchResult);
                }
                case SEARCH_MOVE_LEFT: {
                    inputProcessor.getBuffer().setBufferLine(this.searchResult);
                }
            }
            if (!this.keepFocus()) {
                this.searchArgument = null;
                this.searchResult = null;
                if (this.status != SearchAction.Status.SEARCH_END) {
                    this.moveCursorAtExit(inputProcessor);
                }
            } else if (this.searchArgument == null || this.searchArgument.length() == 0) {
                if (this.searchResult != null) {
                    this.printSearch("", this.searchResult, inputProcessor);
                } else {
                    this.printSearch("", "", inputProcessor);
                }
            } else if (this.searchResult != null && this.searchResult.length() > 0) {
                this.printSearch(this.searchArgument.toString(), this.searchResult, inputProcessor);
            }
        }
    }

    private void printSearch(String searchTerm, String result, InputProcessor inputProcessor) {
        int cursor = result.indexOf(searchTerm);
        StringBuilder builder = inputProcessor.getBuffer().getHistory().getSearchDirection() == SearchDirection.REVERSE ? new StringBuilder("(reverse-i-search) `") : new StringBuilder("(forward-i-search) `");
        builder.append(searchTerm).append("': ");
        cursor += builder.length();
        builder.append(result);
        inputProcessor.getBuffer().getBuffer().disablePrompt(true);
        inputProcessor.getBuffer().moveCursor(-inputProcessor.getBuffer().getBuffer().getCursor());
        inputProcessor.getBuffer().writeOut(ANSI.CURSOR_START);
        inputProcessor.getBuffer().writeOut(ANSI.ERASE_WHOLE_LINE);
        inputProcessor.getBuffer().setBufferLine(builder.toString());
        inputProcessor.getBuffer().moveCursor(cursor - inputProcessor.getBuffer().getBuffer().getCursor());
        inputProcessor.getBuffer().getBuffer().disablePrompt(false);
    }

    private void moveCursorAtExit(InputProcessor inputProcessor) {
        if (this.status == SearchAction.Status.SEARCH_MOVE_RIGHT) {
            inputProcessor.getBuffer().moveCursor(inputProcessor.getBuffer().getBuffer().length());
        }
    }
}

